/*
 * Decompiled with CFR 0.152.
 */
package de.muntjak.tinylookandfeel;

import de.muntjak.tinylookandfeel.Theme;
import de.muntjak.tinylookandfeel.TinyLookAndFeel;
import de.muntjak.tinylookandfeel.TinyUtils;
import de.muntjak.tinylookandfeel.borders.TinyPopupMenuBorder;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.BufferedImage;
import java.util.Iterator;
import java.util.Stack;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLayeredPane;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;

public class TinyPopupFactory
extends PopupFactory {
    private static final boolean DEBUG = false;
    private static final boolean DEBUG_DIALOGS = false;
    public static final String SHADOW_POPUP_KEY = "SHADOW_POPUP_KEY";
    public static final String VERTICAL_IMAGE_KEY = "VERTICAL_IMAGE_KEY";
    public static final String HORIZONTAL_IMAGE_KEY = "HORIZONTAL_IMAGE_KEY";
    public static final String COMPONENT_ORIENTATION_KEY = "COMPONENT_ORIENTATION_KEY";
    private static final Vector DIALOGS = new Vector();
    private static WindowListener activationListener;
    private static final Stack SHADOW_POPUP_CACHE;
    private PopupFactory storedFactory;

    private TinyPopupFactory(PopupFactory popupFactory) {
        this.storedFactory = popupFactory;
    }

    public Popup getPopup(Component component, Component component2, int n, int n2) throws IllegalArgumentException {
        boolean bl;
        Popup popup = super.getPopup(component, component2, n, n2);
        boolean bl2 = bl = component2 instanceof JPopupMenu && ((JComponent)component2).getBorder() instanceof TinyPopupMenuBorder;
        if (bl) {
            return ShadowPopup.getInstance(component, popup, (JPopupMenu)component2, n, n2);
        }
        return popup;
    }

    public static void addDialog(JDialog jDialog) {
        if (TinyUtils.isOSMac()) {
            return;
        }
        if (!jDialog.isModal()) {
            DIALOGS.add(jDialog);
            if (activationListener == null) {
                activationListener = new WindowAdapter(){

                    public void windowActivated(WindowEvent windowEvent) {
                        Window window = windowEvent.getWindow();
                        DIALOGS.remove(window);
                        DIALOGS.add(window);
                    }

                    public void windowClosed(WindowEvent windowEvent) {
                        Window window = windowEvent.getWindow();
                        window.removeWindowListener(activationListener);
                        DIALOGS.remove(window);
                    }
                };
            }
            jDialog.addWindowListener(activationListener);
        }
    }

    public static void closeDialogs() {
        Iterator iterator = DIALOGS.iterator();
        while (iterator.hasNext()) {
            JDialog jDialog = (JDialog)iterator.next();
            jDialog.dispose();
        }
    }

    private static void printDialogs() {
        System.out.println();
        String string = "";
        Iterator iterator = DIALOGS.iterator();
        while (iterator.hasNext()) {
            JDialog jDialog = (JDialog)iterator.next();
            System.out.println(string + jDialog.getTitle());
            string = string + "  ";
        }
    }

    public static void install() {
        if (!TinyPopupFactory.isPopupShadowEnabled()) {
            return;
        }
        PopupFactory popupFactory = PopupFactory.getSharedInstance();
        if (popupFactory instanceof TinyPopupFactory) {
            return;
        }
        if (!DIALOGS.isEmpty()) {
            DIALOGS.clear();
        }
        PopupFactory.setSharedInstance(new TinyPopupFactory(popupFactory));
    }

    public static boolean isPopupShadowEnabled() {
        return !TinyUtils.isOSMac() && Theme.menuPopupShadow.getValue() && TinyLookAndFeel.ROBOT != null;
    }

    public static void uninstall() {
        Object object;
        while (!SHADOW_POPUP_CACHE.empty()) {
            object = SHADOW_POPUP_CACHE.pop();
            object = null;
        }
        while (!DIALOGS.isEmpty()) {
            object = (Window)DIALOGS.get(0);
            ((Window)object).removeWindowListener(activationListener);
            DIALOGS.remove(object);
        }
        object = PopupFactory.getSharedInstance();
        if (!(object instanceof TinyPopupFactory)) {
            return;
        }
        PopupFactory.setSharedInstance(((TinyPopupFactory)object).storedFactory);
    }

    static {
        SHADOW_POPUP_CACHE = new Stack();
    }

    private static class ShadowPopup
    extends Popup {
        private static final Rectangle RECT = new Rectangle();
        private static final Point POINT = new Point();
        private static final Dimension SIZE = new Dimension();
        private Component owner;
        private Popup delegate;
        private JPopupMenu contents;
        private int x;
        private int y;
        private BufferedImage vertImg;
        private BufferedImage horzImg;

        private ShadowPopup(Component component, Popup popup, JPopupMenu jPopupMenu, int n, int n2) {
            this.init(component, popup, jPopupMenu, n, n2);
        }

        static ShadowPopup getInstance(Component component, Popup popup, JPopupMenu jPopupMenu, int n, int n2) {
            if (SHADOW_POPUP_CACHE.empty()) {
                return new ShadowPopup(component, popup, jPopupMenu, n, n2);
            }
            ShadowPopup shadowPopup = (ShadowPopup)SHADOW_POPUP_CACHE.pop();
            shadowPopup.init(component, popup, jPopupMenu, n, n2);
            return shadowPopup;
        }

        private void init(Component component, Popup popup, JPopupMenu jPopupMenu, int n, int n2) {
            this.owner = component;
            this.delegate = popup;
            this.contents = jPopupMenu;
            this.x = n;
            this.y = n2;
            ComponentOrientation componentOrientation = ComponentOrientation.LEFT_TO_RIGHT;
            if (component != null) {
                componentOrientation = component.getComponentOrientation();
            }
            jPopupMenu.putClientProperty(TinyPopupFactory.SHADOW_POPUP_KEY, Boolean.TRUE);
            jPopupMenu.putClientProperty(TinyPopupFactory.COMPONENT_ORIENTATION_KEY, componentOrientation);
        }

        public void show() {
            this.makeSnapshot();
            this.delegate.show();
        }

        public void hide() {
            this.delegate.hide();
            this.uninstall();
        }

        private void makeSnapshot() {
            boolean bl;
            SIZE.setSize(this.contents.getPreferredSize());
            if (ShadowPopup.SIZE.width < 5 || ShadowPopup.SIZE.height < 5) {
                return;
            }
            Object object = this.contents.getClientProperty(TinyPopupFactory.COMPONENT_ORIENTATION_KEY);
            boolean bl2 = bl = object == null ? true : ((ComponentOrientation)object).isLeftToRight();
            if (bl) {
                JLayeredPane jLayeredPane;
                RECT.setBounds(this.x + ShadowPopup.SIZE.width - 5, this.y, 5, ShadowPopup.SIZE.height);
                this.vertImg = TinyLookAndFeel.ROBOT.createScreenCapture(RECT);
                this.contents.putClientProperty(TinyPopupFactory.VERTICAL_IMAGE_KEY, this.vertImg);
                RECT.setBounds(this.x, this.y + ShadowPopup.SIZE.height - 5, ShadowPopup.SIZE.width, 5);
                this.horzImg = TinyLookAndFeel.ROBOT.createScreenCapture(RECT);
                this.contents.putClientProperty(TinyPopupFactory.HORIZONTAL_IMAGE_KEY, this.horzImg);
                JRootPane jRootPane = SwingUtilities.getRootPane(this.owner);
                if (jRootPane != null && (jLayeredPane = jRootPane.getLayeredPane()) != null) {
                    int n;
                    int n2;
                    Iterator iterator;
                    int n3 = jLayeredPane.getWidth();
                    int n4 = jLayeredPane.getHeight();
                    ShadowPopup.POINT.x = this.x;
                    ShadowPopup.POINT.y = this.y;
                    SwingUtilities.convertPointFromScreen(POINT, jLayeredPane);
                    ShadowPopup.RECT.x = ShadowPopup.POINT.x;
                    ShadowPopup.RECT.y = ShadowPopup.POINT.y + ShadowPopup.SIZE.height - 5;
                    ShadowPopup.RECT.width = ShadowPopup.SIZE.width;
                    ShadowPopup.RECT.height = 5;
                    if (ShadowPopup.RECT.x + ShadowPopup.RECT.width > n3) {
                        ShadowPopup.RECT.width = n3 - ShadowPopup.RECT.x;
                    }
                    if (ShadowPopup.RECT.y + ShadowPopup.RECT.height > n4) {
                        ShadowPopup.RECT.height = n4 - ShadowPopup.RECT.y;
                    }
                    Graphics2D graphics2D = this.horzImg.createGraphics();
                    if (!RECT.isEmpty()) {
                        ((Graphics)graphics2D).translate(-ShadowPopup.RECT.x, -ShadowPopup.RECT.y);
                        graphics2D.setClip(RECT);
                        if (jLayeredPane instanceof JComponent) {
                            iterator = jLayeredPane;
                            boolean bl3 = ((JComponent)((Object)iterator)).isDoubleBuffered();
                            ((JComponent)((Object)iterator)).setDoubleBuffered(false);
                            ((Component)((Object)iterator)).paintAll(graphics2D);
                            ((JComponent)((Object)iterator)).setDoubleBuffered(bl3);
                        } else {
                            jLayeredPane.paintAll(graphics2D);
                        }
                        ((Graphics)graphics2D).translate(ShadowPopup.RECT.x, ShadowPopup.RECT.y);
                    }
                    iterator = DIALOGS.iterator();
                    while (iterator.hasNext()) {
                        Window window = (Window)iterator.next();
                        n2 = window.getWidth();
                        n = window.getHeight();
                        ShadowPopup.POINT.x = this.x;
                        ShadowPopup.POINT.y = this.y;
                        SwingUtilities.convertPointFromScreen(POINT, window);
                        ShadowPopup.RECT.x = ShadowPopup.POINT.x;
                        ShadowPopup.RECT.y = ShadowPopup.POINT.y + ShadowPopup.SIZE.height - 5;
                        ShadowPopup.RECT.width = ShadowPopup.SIZE.width;
                        ShadowPopup.RECT.height = 5;
                        if (ShadowPopup.RECT.x + ShadowPopup.RECT.width > n2) {
                            ShadowPopup.RECT.width = n2 - ShadowPopup.RECT.x;
                        }
                        if (ShadowPopup.RECT.y + ShadowPopup.RECT.height > n) {
                            ShadowPopup.RECT.height = n - ShadowPopup.RECT.y;
                        }
                        if (RECT.isEmpty()) continue;
                        ((Graphics)graphics2D).translate(-ShadowPopup.RECT.x, -ShadowPopup.RECT.y);
                        graphics2D.setClip(RECT);
                        window.paintAll(graphics2D);
                        ((Graphics)graphics2D).translate(ShadowPopup.RECT.x, ShadowPopup.RECT.y);
                    }
                    graphics2D.dispose();
                    ShadowPopup.POINT.x = this.x;
                    ShadowPopup.POINT.y = this.y;
                    SwingUtilities.convertPointFromScreen(POINT, jLayeredPane);
                    ShadowPopup.RECT.x = ShadowPopup.POINT.x + ShadowPopup.SIZE.width - 5;
                    ShadowPopup.RECT.y = ShadowPopup.POINT.y;
                    ShadowPopup.RECT.width = 5;
                    ShadowPopup.RECT.height = ShadowPopup.SIZE.height;
                    if (ShadowPopup.RECT.x + ShadowPopup.RECT.width > n3) {
                        ShadowPopup.RECT.width = n3 - ShadowPopup.RECT.x;
                    }
                    if (ShadowPopup.RECT.y + ShadowPopup.RECT.height > n4) {
                        ShadowPopup.RECT.height = n4 - ShadowPopup.RECT.y;
                    }
                    graphics2D = this.vertImg.createGraphics();
                    if (!RECT.isEmpty()) {
                        ((Graphics)graphics2D).translate(-ShadowPopup.RECT.x, -ShadowPopup.RECT.y);
                        graphics2D.setClip(RECT);
                        if (jLayeredPane instanceof JComponent) {
                            JLayeredPane jLayeredPane2 = jLayeredPane;
                            n2 = jLayeredPane2.isDoubleBuffered() ? 1 : 0;
                            jLayeredPane2.setDoubleBuffered(false);
                            jLayeredPane2.paintAll(graphics2D);
                            jLayeredPane2.setDoubleBuffered(n2 != 0);
                        } else {
                            jLayeredPane.paintAll(graphics2D);
                        }
                        ((Graphics)graphics2D).translate(ShadowPopup.RECT.x, ShadowPopup.RECT.y);
                    }
                    iterator = DIALOGS.iterator();
                    while (iterator.hasNext()) {
                        Window window = (Window)iterator.next();
                        n2 = window.getWidth();
                        n = window.getHeight();
                        ShadowPopup.POINT.x = this.x;
                        ShadowPopup.POINT.y = this.y;
                        SwingUtilities.convertPointFromScreen(POINT, window);
                        ShadowPopup.RECT.x = ShadowPopup.POINT.x + ShadowPopup.SIZE.width - 5;
                        ShadowPopup.RECT.y = ShadowPopup.POINT.y;
                        ShadowPopup.RECT.width = 5;
                        ShadowPopup.RECT.height = ShadowPopup.SIZE.height;
                        if (ShadowPopup.RECT.x + ShadowPopup.RECT.width > n2) {
                            ShadowPopup.RECT.width = n2 - ShadowPopup.RECT.x;
                        }
                        if (ShadowPopup.RECT.y + ShadowPopup.RECT.height > n) {
                            ShadowPopup.RECT.height = n - ShadowPopup.RECT.y;
                        }
                        if (RECT.isEmpty()) continue;
                        ((Graphics)graphics2D).translate(-ShadowPopup.RECT.x, -ShadowPopup.RECT.y);
                        graphics2D.setClip(RECT);
                        window.paintAll(graphics2D);
                        ((Graphics)graphics2D).translate(ShadowPopup.RECT.x, ShadowPopup.RECT.y);
                    }
                    graphics2D.dispose();
                }
            } else {
                JLayeredPane jLayeredPane;
                RECT.setBounds(this.x, this.y, 5, ShadowPopup.SIZE.height);
                this.vertImg = TinyLookAndFeel.ROBOT.createScreenCapture(RECT);
                this.contents.putClientProperty(TinyPopupFactory.VERTICAL_IMAGE_KEY, this.vertImg);
                RECT.setBounds(this.x, this.y + ShadowPopup.SIZE.height - 5, ShadowPopup.SIZE.width, 5);
                this.horzImg = TinyLookAndFeel.ROBOT.createScreenCapture(RECT);
                this.contents.putClientProperty(TinyPopupFactory.HORIZONTAL_IMAGE_KEY, this.horzImg);
                JRootPane jRootPane = SwingUtilities.getRootPane(this.owner);
                if (jRootPane != null && (jLayeredPane = jRootPane.getLayeredPane()) != null) {
                    int n;
                    int n5;
                    Iterator iterator;
                    int n6 = jLayeredPane.getWidth();
                    int n7 = jLayeredPane.getHeight();
                    ShadowPopup.POINT.x = this.x;
                    ShadowPopup.POINT.y = this.y;
                    SwingUtilities.convertPointFromScreen(POINT, jLayeredPane);
                    ShadowPopup.RECT.x = ShadowPopup.POINT.x;
                    ShadowPopup.RECT.y = ShadowPopup.POINT.y + ShadowPopup.SIZE.height - 5;
                    ShadowPopup.RECT.width = ShadowPopup.SIZE.width;
                    ShadowPopup.RECT.height = 5;
                    if (ShadowPopup.RECT.x + ShadowPopup.RECT.width > n6) {
                        ShadowPopup.RECT.width = n6 - ShadowPopup.RECT.x;
                    }
                    if (ShadowPopup.RECT.y + ShadowPopup.RECT.height > n7) {
                        ShadowPopup.RECT.height = n7 - ShadowPopup.RECT.y;
                    }
                    Graphics2D graphics2D = this.horzImg.createGraphics();
                    if (!RECT.isEmpty()) {
                        ((Graphics)graphics2D).translate(-ShadowPopup.RECT.x, -ShadowPopup.RECT.y);
                        graphics2D.setClip(RECT);
                        if (jLayeredPane instanceof JComponent) {
                            iterator = jLayeredPane;
                            boolean bl4 = ((JComponent)((Object)iterator)).isDoubleBuffered();
                            ((JComponent)((Object)iterator)).setDoubleBuffered(false);
                            ((Component)((Object)iterator)).paintAll(graphics2D);
                            ((JComponent)((Object)iterator)).setDoubleBuffered(bl4);
                        } else {
                            jLayeredPane.paintAll(graphics2D);
                        }
                        ((Graphics)graphics2D).translate(ShadowPopup.RECT.x, ShadowPopup.RECT.y);
                    }
                    iterator = DIALOGS.iterator();
                    while (iterator.hasNext()) {
                        Window window = (Window)iterator.next();
                        n5 = window.getWidth();
                        n = window.getHeight();
                        ShadowPopup.POINT.x = this.x;
                        ShadowPopup.POINT.y = this.y;
                        SwingUtilities.convertPointFromScreen(POINT, window);
                        ShadowPopup.RECT.x = ShadowPopup.POINT.x;
                        ShadowPopup.RECT.y = ShadowPopup.POINT.y + ShadowPopup.SIZE.height - 5;
                        ShadowPopup.RECT.width = ShadowPopup.SIZE.width;
                        ShadowPopup.RECT.height = 5;
                        if (ShadowPopup.RECT.x + ShadowPopup.RECT.width > n5) {
                            ShadowPopup.RECT.width = n5 - ShadowPopup.RECT.x;
                        }
                        if (ShadowPopup.RECT.y + ShadowPopup.RECT.height > n) {
                            ShadowPopup.RECT.height = n - ShadowPopup.RECT.y;
                        }
                        if (RECT.isEmpty()) continue;
                        ((Graphics)graphics2D).translate(-ShadowPopup.RECT.x, -ShadowPopup.RECT.y);
                        graphics2D.setClip(RECT);
                        window.paintAll(graphics2D);
                        ((Graphics)graphics2D).translate(ShadowPopup.RECT.x, ShadowPopup.RECT.y);
                    }
                    graphics2D.dispose();
                    ShadowPopup.POINT.x = this.x;
                    ShadowPopup.POINT.y = this.y;
                    SwingUtilities.convertPointFromScreen(POINT, jLayeredPane);
                    ShadowPopup.RECT.x = ShadowPopup.POINT.x;
                    ShadowPopup.RECT.y = ShadowPopup.POINT.y;
                    ShadowPopup.RECT.width = 5;
                    ShadowPopup.RECT.height = ShadowPopup.SIZE.height;
                    if (ShadowPopup.RECT.x + ShadowPopup.RECT.width > n6) {
                        ShadowPopup.RECT.width = n6 - ShadowPopup.RECT.x;
                    }
                    if (ShadowPopup.RECT.y + ShadowPopup.RECT.height > n7) {
                        ShadowPopup.RECT.height = n7 - ShadowPopup.RECT.y;
                    }
                    graphics2D = this.vertImg.createGraphics();
                    if (!RECT.isEmpty()) {
                        ((Graphics)graphics2D).translate(-ShadowPopup.RECT.x, -ShadowPopup.RECT.y);
                        graphics2D.setClip(RECT);
                        if (jLayeredPane instanceof JComponent) {
                            JLayeredPane jLayeredPane3 = jLayeredPane;
                            n5 = jLayeredPane3.isDoubleBuffered() ? 1 : 0;
                            jLayeredPane3.setDoubleBuffered(false);
                            jLayeredPane3.paintAll(graphics2D);
                            jLayeredPane3.setDoubleBuffered(n5 != 0);
                        } else {
                            jLayeredPane.paintAll(graphics2D);
                        }
                        ((Graphics)graphics2D).translate(ShadowPopup.RECT.x, ShadowPopup.RECT.y);
                    }
                    iterator = DIALOGS.iterator();
                    while (iterator.hasNext()) {
                        Window window = (Window)iterator.next();
                        n5 = window.getWidth();
                        n = window.getHeight();
                        ShadowPopup.POINT.x = this.x;
                        ShadowPopup.POINT.y = this.y;
                        SwingUtilities.convertPointFromScreen(POINT, window);
                        ShadowPopup.RECT.x = ShadowPopup.POINT.x;
                        ShadowPopup.RECT.y = ShadowPopup.POINT.y;
                        ShadowPopup.RECT.width = 5;
                        ShadowPopup.RECT.height = ShadowPopup.SIZE.height;
                        if (ShadowPopup.RECT.x + ShadowPopup.RECT.width > n5) {
                            ShadowPopup.RECT.width = n5 - ShadowPopup.RECT.x;
                        }
                        if (ShadowPopup.RECT.y + ShadowPopup.RECT.height > n) {
                            ShadowPopup.RECT.height = n - ShadowPopup.RECT.y;
                        }
                        if (RECT.isEmpty()) continue;
                        ((Graphics)graphics2D).translate(-ShadowPopup.RECT.x, -ShadowPopup.RECT.y);
                        graphics2D.setClip(RECT);
                        window.paintAll(graphics2D);
                        ((Graphics)graphics2D).translate(ShadowPopup.RECT.x, ShadowPopup.RECT.y);
                    }
                    graphics2D.dispose();
                }
            }
        }

        private void uninstall() {
            this.contents.putClientProperty(TinyPopupFactory.SHADOW_POPUP_KEY, null);
            this.contents.putClientProperty(TinyPopupFactory.COMPONENT_ORIENTATION_KEY, null);
            this.contents.putClientProperty(TinyPopupFactory.VERTICAL_IMAGE_KEY, null);
            this.contents.putClientProperty(TinyPopupFactory.HORIZONTAL_IMAGE_KEY, null);
            this.contents = null;
            this.delegate = null;
            this.vertImg = null;
            this.horzImg = null;
            SHADOW_POPUP_CACHE.push(this);
        }
    }
}

