#!/bin/sh
#*****************************************************************************
# This script is used to start MegaLogViewer
#
#*****************************************************************************

LAST_PATH=`pwd -P`


TARGET_FILE=$0

cd `dirname $TARGET_FILE`
TARGET_FILE=`basename $TARGET_FILE`

# Iterate down a (possible) chain of symlinks
while [ -L "$TARGET_FILE" ]
do
    TARGET_FILE=`readlink $TARGET_FILE`
    cd `dirname $TARGET_FILE`
    TARGET_FILE=`basename $TARGET_FILE`
done

# Compute the canonicalized name by finding the physical path 
# for the directory we're in and appending the target file.
PHYS_DIR=`pwd -P`
#SCRIPT=$PHYS_DIR/$TARGET_FILE
#echo $SCRIPT

# All the above is to replace this linux command
#SCRIPT=$( readlink -f $0 )

BASE_PATH=$PHYS_DIR
#BASE_PATH="${SCRIPT%/*}"
#LAST_PATH="$PWD"
echo BASE_PATH equals: $BASE_PATH

if [ -e $BASE_PATH/DynoSpectrum.properties ]; then
    # file exists, do nothing
    echo Passed Dir Check
else
	echo "This script must be located in the MegaLogViewer directory. To be able"
	echo "to launch without path create a symlink of this script to a directory in PATH."
	echo
	echo "Example: ln -s /home/john_doe/DynoSpectrum/DynoSpectrum.sh /usr/local/bin"
	exit 1
fi

if [ -e $BASE_PATH/runtime ]; then
echo setting JAVA_HOME
export JAVA_HOME=$BASE_PATH/runtime
export PATH=$PATH:$BASE_PATH/runtime/bin

fi

#cd "$BASE_PATH" && java -Xms512m -Xmx2048m -jar DynoSpectrum.jar $1
cd "$BASE_PATH" && java -jar DynoSpectrum.jar $1
RESULT=$?

if [ -d "$LAST_PATH" ]; then
	cd "$LAST_PATH"
fi

exit $RESULT