/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.util.content;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.icepdf.core.pobjects.Form;
import org.icepdf.core.pobjects.ImageStream;
import org.icepdf.core.pobjects.Name;
import org.icepdf.core.pobjects.OptionalContent;
import org.icepdf.core.pobjects.OptionalContentGroup;
import org.icepdf.core.pobjects.OptionalContents;
import org.icepdf.core.pobjects.PRectangle;
import org.icepdf.core.pobjects.Reference;
import org.icepdf.core.pobjects.Resources;
import org.icepdf.core.pobjects.StringObject;
import org.icepdf.core.pobjects.fonts.Font;
import org.icepdf.core.pobjects.fonts.FontFactory;
import org.icepdf.core.pobjects.fonts.FontFile;
import org.icepdf.core.pobjects.graphics.DeviceCMYK;
import org.icepdf.core.pobjects.graphics.DeviceGray;
import org.icepdf.core.pobjects.graphics.DeviceRGB;
import org.icepdf.core.pobjects.graphics.ExtGState;
import org.icepdf.core.pobjects.graphics.GlyphOutlineClip;
import org.icepdf.core.pobjects.graphics.GraphicsState;
import org.icepdf.core.pobjects.graphics.ImageReference;
import org.icepdf.core.pobjects.graphics.ImageReferenceFactory;
import org.icepdf.core.pobjects.graphics.PColorSpace;
import org.icepdf.core.pobjects.graphics.Pattern;
import org.icepdf.core.pobjects.graphics.PatternColor;
import org.icepdf.core.pobjects.graphics.ShadingPattern;
import org.icepdf.core.pobjects.graphics.Shapes;
import org.icepdf.core.pobjects.graphics.TextSprite;
import org.icepdf.core.pobjects.graphics.TextState;
import org.icepdf.core.pobjects.graphics.TilingPattern;
import org.icepdf.core.pobjects.graphics.commands.AlphaDrawCmd;
import org.icepdf.core.pobjects.graphics.commands.ClipDrawCmd;
import org.icepdf.core.pobjects.graphics.commands.ColorDrawCmd;
import org.icepdf.core.pobjects.graphics.commands.DrawDrawCmd;
import org.icepdf.core.pobjects.graphics.commands.FillDrawCmd;
import org.icepdf.core.pobjects.graphics.commands.FormDrawCmd;
import org.icepdf.core.pobjects.graphics.commands.ImageDrawCmd;
import org.icepdf.core.pobjects.graphics.commands.NoClipDrawCmd;
import org.icepdf.core.pobjects.graphics.commands.OCGEndDrawCmd;
import org.icepdf.core.pobjects.graphics.commands.OCGStartDrawCmd;
import org.icepdf.core.pobjects.graphics.commands.PaintDrawCmd;
import org.icepdf.core.pobjects.graphics.commands.ShapeDrawCmd;
import org.icepdf.core.pobjects.graphics.commands.ShapesDrawCmd;
import org.icepdf.core.pobjects.graphics.commands.StrokeDrawCmd;
import org.icepdf.core.pobjects.graphics.commands.TextSpriteDrawCmd;
import org.icepdf.core.pobjects.graphics.commands.TilingPatternDrawCmd;
import org.icepdf.core.pobjects.graphics.commands.TransformDrawCmd;
import org.icepdf.core.pobjects.graphics.text.GlyphText;
import org.icepdf.core.pobjects.graphics.text.PageText;
import org.icepdf.core.util.Defs;
import org.icepdf.core.util.Library;
import org.icepdf.core.util.content.ContentParser;
import org.icepdf.core.util.content.TextMetrics;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractContentParser
implements ContentParser {
    private static final Logger logger = Logger.getLogger(AbstractContentParser.class.toString());
    private static boolean disableTransparencyGroups = Defs.sysPropertyBoolean("org.icepdf.core.disableTransparencyGroup", false);
    public static final float OVERPAINT_ALPHA = 0.4f;
    protected GraphicsState graphicState;
    protected Library library;
    protected Resources resources;
    protected Shapes shapes;
    protected LinkedList<OptionalContents> oCGs;
    protected GeneralPath geometricPath;
    protected boolean inTextBlock;
    protected AffineTransform textBlockBase;
    protected Stack<Object> stack = new Stack();

    public AbstractContentParser(Library l, Resources r) {
        this.library = l;
        this.resources = r;
    }

    @Override
    public Shapes getShapes() {
        this.shapes.contract();
        return this.shapes;
    }

    @Override
    public Stack<Object> getStack() {
        return this.stack;
    }

    @Override
    public GraphicsState getGraphicsState() {
        return this.graphicState;
    }

    @Override
    public void setGraphicsState(GraphicsState graphicState) {
        this.graphicState = graphicState;
    }

    @Override
    public abstract ContentParser parse(byte[][] var1) throws InterruptedException, IOException;

    @Override
    public abstract Shapes parseTextBlocks(byte[][] var1) throws UnsupportedEncodingException;

    protected static void consume_G(GraphicsState graphicState, Stack stack, Library library) {
        float gray = ((Number)stack.pop()).floatValue();
        graphicState.setStrokeColorSpace(PColorSpace.getColorSpace(library, DeviceGray.DEVICEGRAY_KEY));
        graphicState.setStrokeColor(new Color(gray, gray, gray));
    }

    protected static void consume_g(GraphicsState graphicState, Stack stack, Library library) {
        float gray = ((Number)stack.pop()).floatValue();
        graphicState.setFillColorSpace(PColorSpace.getColorSpace(library, DeviceGray.DEVICEGRAY_KEY));
        graphicState.setFillColor(new Color(gray, gray, gray));
    }

    protected static void consume_RG(GraphicsState graphicState, Stack stack, Library library) {
        float b = ((Number)stack.pop()).floatValue();
        float gg = ((Number)stack.pop()).floatValue();
        float r = ((Number)stack.pop()).floatValue();
        b = Math.max(0.0f, Math.min(1.0f, b));
        gg = Math.max(0.0f, Math.min(1.0f, gg));
        r = Math.max(0.0f, Math.min(1.0f, r));
        graphicState.setStrokeColorSpace(PColorSpace.getColorSpace(library, DeviceRGB.DEVICERGB_KEY));
        graphicState.setStrokeColor(new Color(r, gg, b));
    }

    protected static void consume_rg(GraphicsState graphicState, Stack stack, Library library) {
        float b = ((Number)stack.pop()).floatValue();
        float gg = ((Number)stack.pop()).floatValue();
        float r = ((Number)stack.pop()).floatValue();
        b = Math.max(0.0f, Math.min(1.0f, b));
        gg = Math.max(0.0f, Math.min(1.0f, gg));
        r = Math.max(0.0f, Math.min(1.0f, r));
        graphicState.setFillColorSpace(PColorSpace.getColorSpace(library, DeviceRGB.DEVICERGB_KEY));
        graphicState.setFillColor(new Color(r, gg, b));
    }

    protected static void consume_K(GraphicsState graphicState, Stack stack, Library library) {
        float k = ((Number)stack.pop()).floatValue();
        float y = ((Number)stack.pop()).floatValue();
        float m = ((Number)stack.pop()).floatValue();
        float c = ((Number)stack.pop()).floatValue();
        PColorSpace pColorSpace = PColorSpace.getColorSpace(library, DeviceCMYK.DEVICECMYK_KEY);
        graphicState.setStrokeColorSpace(pColorSpace);
        graphicState.setStrokeColor(pColorSpace.getColor(new float[]{k, y, m, c}, true));
    }

    protected static void consume_k(GraphicsState graphicState, Stack stack, Library library) {
        float k = ((Number)stack.pop()).floatValue();
        float y = ((Number)stack.pop()).floatValue();
        float m = ((Number)stack.pop()).floatValue();
        float c = ((Number)stack.pop()).floatValue();
        PColorSpace pColorSpace = PColorSpace.getColorSpace(library, DeviceCMYK.DEVICECMYK_KEY);
        graphicState.setFillColorSpace(pColorSpace);
        graphicState.setFillColor(pColorSpace.getColor(new float[]{k, y, m, c}, true));
    }

    protected static void consume_CS(GraphicsState graphicState, Stack stack, Resources resources) {
        Name n = (Name)stack.pop();
        graphicState.setStrokeColorSpace(resources.getColorSpace(n));
    }

    protected static void consume_cs(GraphicsState graphicState, Stack stack, Resources resources) {
        Name n = (Name)stack.pop();
        graphicState.setFillColorSpace(resources.getColorSpace(n));
    }

    protected static void consume_ri(Stack stack) {
        stack.pop();
    }

    protected static void consume_SC(GraphicsState graphicState, Stack stack, Library library, Resources resources, boolean isTint) {
        Object o = stack.peek();
        if (o instanceof Name) {
            TilingPattern tilingPattern;
            PatternColor pc;
            Name patternName = (Name)stack.pop();
            Pattern pattern = resources.getPattern(patternName);
            if (graphicState.getStrokeColorSpace() instanceof PatternColor) {
                pc = (PatternColor)graphicState.getStrokeColorSpace();
                pc.setPattern(pattern);
            } else {
                pc = new PatternColor(null, null);
                pc.setPattern(pattern);
                graphicState.setStrokeColorSpace(pc);
            }
            if (pattern instanceof TilingPattern && (tilingPattern = (TilingPattern)pattern).getPaintType() == 2) {
                int compLength = graphicState.getStrokeColorSpace().getNumComponents();
                float[] colour = new float[compLength];
                for (int nCount = 0; !stack.isEmpty() && stack.peek() instanceof Number && nCount < compLength; ++nCount) {
                    colour[nCount] = ((Number)stack.pop()).floatValue();
                }
                Color color = graphicState.getStrokeColorSpace().getColor(colour, isTint);
                graphicState.setStrokeColor(color);
                tilingPattern.setUnColored(color);
            }
        } else if (o instanceof Number) {
            int nCount;
            int colorSpaceN = graphicState.getStrokeColorSpace().getNumComponents();
            int compLength = 4;
            float[] colour = new float[compLength];
            for (nCount = 0; !stack.isEmpty() && stack.peek() instanceof Number && nCount < compLength; ++nCount) {
                colour[nCount] = ((Number)stack.pop()).floatValue();
            }
            if (nCount != colorSpaceN) {
                graphicState.setStrokeColorSpace(PColorSpace.getColorSpace(library, nCount));
            }
            float[] f = new float[nCount];
            System.arraycopy(colour, 0, f, 0, nCount);
            graphicState.setStrokeColor(graphicState.getStrokeColorSpace().getColor(f, isTint));
        }
    }

    protected static void consume_sc(GraphicsState graphicState, Stack stack, Library library, Resources resources, boolean isTint) {
        Object o = stack.peek();
        if (o instanceof Name) {
            TilingPattern tilingPattern;
            PatternColor pc;
            Name patternName = (Name)stack.pop();
            Pattern pattern = resources.getPattern(patternName);
            if (graphicState.getFillColorSpace() instanceof PatternColor) {
                pc = (PatternColor)graphicState.getFillColorSpace();
                pc.setPattern(pattern);
            } else {
                pc = new PatternColor(library, null);
                pc.setPattern(pattern);
                graphicState.setFillColorSpace(pc);
            }
            if (pattern instanceof TilingPattern && (tilingPattern = (TilingPattern)pattern).getPaintType() == 2) {
                int compLength = graphicState.getFillColorSpace().getNumComponents();
                float[] colour = new float[compLength];
                for (int nCount = 0; !stack.isEmpty() && stack.peek() instanceof Number && nCount < compLength; ++nCount) {
                    colour[nCount] = ((Number)stack.pop()).floatValue();
                }
                Color color = graphicState.getFillColorSpace().getColor(colour, isTint);
                graphicState.setFillColor(color);
                tilingPattern.setUnColored(color);
            }
        } else if (o instanceof Number) {
            int nCount;
            int colorSpaceN = graphicState.getFillColorSpace().getNumComponents();
            int compLength = 4;
            float[] colour = new float[compLength];
            for (nCount = 0; !stack.isEmpty() && stack.peek() instanceof Number && nCount < compLength; ++nCount) {
                colour[nCount] = ((Number)stack.pop()).floatValue();
            }
            if (nCount != colorSpaceN) {
                graphicState.setFillColorSpace(PColorSpace.getColorSpace(library, nCount));
            }
            float[] f = new float[nCount];
            System.arraycopy(colour, 0, f, 0, nCount);
            graphicState.setFillColor(graphicState.getFillColorSpace().getColor(f, isTint));
        }
    }

    protected static GraphicsState consume_q(GraphicsState graphicState) {
        return graphicState.save();
    }

    protected GraphicsState consume_Q(GraphicsState graphicState, Shapes shapes) {
        GraphicsState gs1 = graphicState.restore();
        if (gs1 != null) {
            graphicState = gs1;
        } else {
            graphicState = new GraphicsState(shapes);
            graphicState.set(new AffineTransform());
            shapes.add(new NoClipDrawCmd());
        }
        return graphicState;
    }

    protected static void consume_cm(GraphicsState graphicState, Stack stack, boolean inTextBlock, AffineTransform textBlockBase) {
        float f = ((Number)stack.pop()).floatValue();
        float e = ((Number)stack.pop()).floatValue();
        float d = ((Number)stack.pop()).floatValue();
        float c = ((Number)stack.pop()).floatValue();
        float b = ((Number)stack.pop()).floatValue();
        float a = ((Number)stack.pop()).floatValue();
        AffineTransform af = new AffineTransform(graphicState.getCTM());
        af.concatenate(new AffineTransform(a, b, c, d, e, f));
        graphicState.set(af);
        graphicState.updateClipCM(new AffineTransform(a, b, c, d, e, f));
        if (inTextBlock) {
            af = new AffineTransform(textBlockBase);
            graphicState.getTextState().tmatrix = new AffineTransform(a, b, c, d, e, f);
            af.concatenate(graphicState.getTextState().tmatrix);
            graphicState.set(af);
            textBlockBase.setTransform(new AffineTransform(graphicState.getCTM()));
        }
    }

    protected static void consume_i(Stack stack) {
        stack.pop();
    }

    protected static void consume_J(GraphicsState graphicState, Stack stack, Shapes shapes) {
        graphicState.setLineCap((int)((Number)stack.pop()).floatValue());
        if (graphicState.getLineCap() == 0) {
            graphicState.setLineCap(0);
        } else if (graphicState.getLineCap() == 1) {
            graphicState.setLineCap(1);
        } else if (graphicState.getLineCap() == 2) {
            graphicState.setLineCap(2);
        }
        AbstractContentParser.setStroke(shapes, graphicState);
    }

    protected static GraphicsState consume_Do(GraphicsState graphicState, Stack stack, Shapes shapes, Resources resources, boolean viewParse) {
        Name xobjectName = (Name)stack.pop();
        if (resources != null && resources.isForm(xobjectName)) {
            graphicState = graphicState.save();
            Form formXObject = resources.getForm(xobjectName);
            if (formXObject != null) {
                Object oc = formXObject.getObject(OptionalContent.OC_KEY);
                if (oc != null) {
                    OptionalContent optionalContent = resources.getLibrary().getCatalog().getOptionalContent();
                    optionalContent.init();
                    if (!optionalContent.isVisible(oc)) {
                        return graphicState;
                    }
                }
                GraphicsState xformGraphicsState = new GraphicsState(graphicState);
                formXObject.setGraphicsState(xformGraphicsState);
                if (formXObject.isTransparencyGroup()) {
                    xformGraphicsState.setTransparencyGroup(formXObject.isTransparencyGroup());
                    xformGraphicsState.setIsolated(formXObject.isIsolated());
                    xformGraphicsState.setKnockOut(formXObject.isKnockOut());
                }
                formXObject.setParentResources(resources);
                formXObject.init();
                AffineTransform af = new AffineTransform(graphicState.getCTM());
                af.concatenate(formXObject.getMatrix());
                shapes.add(new TransformDrawCmd(af));
                if (graphicState.getClip() != null) {
                    AffineTransform matrix = formXObject.getMatrix();
                    Area bbox = new Area(formXObject.getBBox());
                    Area clip = graphicState.getClip();
                    try {
                        matrix = matrix.createInverse();
                    }
                    catch (NoninvertibleTransformException e) {
                        logger.warning("Error create xObject matrix inverse");
                    }
                    Shape shape = matrix.createTransformedShape(clip);
                    bbox.intersect(new Area(shape));
                    shapes.add(new ShapeDrawCmd(bbox));
                } else {
                    shapes.add(new ShapeDrawCmd(formXObject.getBBox()));
                }
                shapes.add(new ClipDrawCmd());
                AbstractContentParser.setAlpha(shapes, graphicState.getAlphaRule(), graphicState.getFillAlpha());
                if (!disableTransparencyGroups && formXObject.isTransparencyGroup() && graphicState.getFillAlpha() < 1.0f && formXObject.getBBox().getWidth() < 32767.0 && formXObject.getBBox().getHeight() < 32767.0) {
                    shapes.add(new FormDrawCmd(formXObject));
                } else {
                    shapes.add(new ShapesDrawCmd(formXObject.getShapes()));
                }
                if (formXObject.getShapes() != null && formXObject.getShapes().getPageText() != null) {
                    formXObject.getShapes().getPageText().applyXObjectTransform(graphicState.getCTM());
                    shapes.getPageText().addPageLines(formXObject.getShapes().getPageText().getPageLines());
                }
                shapes.add(new NoClipDrawCmd());
            }
            graphicState = graphicState.restore();
        } else if (viewParse) {
            AbstractContentParser.setAlpha(shapes, graphicState.getAlphaRule(), graphicState.getFillAlpha());
            ImageStream imageStream = resources.getImageStream(xobjectName);
            if (imageStream != null) {
                ImageReference imageReference;
                Object oc = imageStream.getObject(OptionalContent.OC_KEY);
                if (oc != null) {
                    OptionalContent optionalContent = resources.getLibrary().getCatalog().getOptionalContent();
                    optionalContent.init();
                    if (!optionalContent.isVisible(oc)) {
                        return graphicState;
                    }
                }
                if ((imageReference = ImageReferenceFactory.getImageReference(imageStream, resources, graphicState.getFillColor())) != null) {
                    AffineTransform af = new AffineTransform(graphicState.getCTM());
                    graphicState.scale(1.0, -1.0);
                    graphicState.translate(0.0, -1.0);
                    shapes.add(new ImageDrawCmd(imageReference));
                    graphicState.set(af);
                }
            }
        }
        return graphicState;
    }

    protected static void consume_d(GraphicsState graphicState, Stack stack, Shapes shapes) {
        try {
            float[] dashArray;
            float dashPhase = Math.abs(((Number)stack.pop()).floatValue());
            List dashVector = (List)stack.pop();
            if (dashVector.size() > 0) {
                int sz = dashVector.size();
                dashArray = new float[sz];
                for (int i = 0; i < sz; ++i) {
                    dashArray[i] = Math.abs(((Number)dashVector.get(i)).floatValue());
                }
                if (dashArray.length > 1 && dashArray[0] != 0.0f && dashArray[0] < dashArray[1] / 10000.0f) {
                    dashArray[0] = dashArray[1];
                }
            } else {
                dashPhase = 0.0f;
                dashArray = null;
            }
            graphicState.setDashArray(dashArray);
            graphicState.setDashPhase(dashPhase);
        }
        catch (ClassCastException e) {
            logger.log(Level.FINE, "Dash pattern syntax error: ", e);
        }
        AbstractContentParser.setStroke(shapes, graphicState);
    }

    protected static void consume_j(GraphicsState graphicState, Stack stack, Shapes shapes) {
        graphicState.setLineJoin((int)((Number)stack.pop()).floatValue());
        if (graphicState.getLineJoin() == 0) {
            graphicState.setLineJoin(0);
        } else if (graphicState.getLineJoin() == 1) {
            graphicState.setLineJoin(1);
        } else if (graphicState.getLineJoin() == 2) {
            graphicState.setLineJoin(2);
        }
        AbstractContentParser.setStroke(shapes, graphicState);
    }

    protected static void consume_w(GraphicsState graphicState, Stack stack, Shapes shapes) {
        graphicState.setLineWidth(((Number)stack.pop()).floatValue());
        AbstractContentParser.setStroke(shapes, graphicState);
    }

    protected static void consume_M(GraphicsState graphicState, Stack stack, Shapes shapes) {
        graphicState.setMiterLimit(((Number)stack.pop()).floatValue());
        AbstractContentParser.setStroke(shapes, graphicState);
    }

    protected static void consume_gs(GraphicsState graphicState, Stack stack, Resources resources) {
        ExtGState extGState;
        Object gs = stack.pop();
        if (gs instanceof Name && resources != null && (extGState = resources.getExtGState((Name)gs)) != null) {
            graphicState.concatenate(extGState);
        }
    }

    protected static void consume_Tf(GraphicsState graphicState, Stack stack, Resources resources) {
        float size = ((Number)stack.pop()).floatValue();
        Name name2 = (Name)stack.pop();
        graphicState.getTextState().font = resources.getFont(name2);
        if (graphicState.getTextState().font == null || graphicState.getTextState().font.getFont() == null) {
            FontFactory fontFactory = FontFactory.getInstance();
            boolean awtState = fontFactory.isAwtFontSubstitution();
            fontFactory.setAwtFontSubstitution(true);
            Resources res = resources.getLibrary().getCatalog().getPageTree().getPage(0).getResources();
            Object pageFonts = res.getEntries().get(Resources.FONT_KEY);
            if (pageFonts instanceof HashMap) {
                Reference fontRef = (Reference)((HashMap)pageFonts).get(name2);
                graphicState.getTextState().font = (Font)resources.getLibrary().getObject(fontRef);
                graphicState.getTextState().font.init();
            }
            fontFactory.setAwtFontSubstitution(awtState);
        }
        graphicState.getTextState().currentfont = graphicState.getTextState().font.getFont().deriveFont(size);
    }

    protected static void consume_Tc(GraphicsState graphicState, Stack stack) {
        graphicState.getTextState().cspace = ((Number)stack.pop()).floatValue();
    }

    protected static void consume_tm(GraphicsState graphicState, Stack stack, TextMetrics textMetrics, PageText pageText, double previousBTStart, AffineTransform textBlockBase, LinkedList<OptionalContents> oCGs) {
        textMetrics.setShift(0.0f);
        textMetrics.setPreviousAdvance(0.0f);
        textMetrics.getAdvance().setLocation(0.0f, 0.0f);
        float[] tm = new float[]{1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f};
        int hits = 5;
        int max = stack.size();
        for (int i = 0; hits != -1 && i < max; ++i) {
            Object next = stack.pop();
            if (!(next instanceof Number)) continue;
            tm[hits] = ((Number)next).floatValue();
            --hits;
        }
        AffineTransform af = new AffineTransform(textBlockBase);
        double oldTransY = graphicState.getCTM().getTranslateY();
        double oldScaleY = graphicState.getCTM().getScaleY();
        graphicState.getTextState().tmatrix = new AffineTransform(tm);
        af.concatenate(graphicState.getTextState().tmatrix);
        graphicState.set(af);
        graphicState.scale(1.0, -1.0);
        if (textMetrics.isYstart()) {
            textMetrics.setyBTStart(tm[5]);
            textMetrics.setYstart(false);
            if (previousBTStart != (double)textMetrics.getyBTStart()) {
                pageText.newLine(oCGs);
            }
        }
        double newTransY = graphicState.getCTM().getTranslateY();
        double newScaleY = graphicState.getCTM().getScaleY();
        if (Math.round(oldTransY) != Math.round(newTransY)) {
            pageText.newLine(oCGs);
        } else if (Math.abs(oldScaleY) != Math.abs(newScaleY)) {
            pageText.newLine(oCGs);
        }
    }

    protected static void consume_T_star(GraphicsState graphicState, TextMetrics textMetrics, PageText pageText, LinkedList<OptionalContents> oCGs) {
        graphicState.translate(-textMetrics.getShift(), 0.0);
        textMetrics.setShift(0.0f);
        textMetrics.setPreviousAdvance(0.0f);
        textMetrics.getAdvance().setLocation(0.0f, 0.0f);
        graphicState.translate(0.0, graphicState.getTextState().leading);
        pageText.newLine(oCGs);
    }

    protected static void consume_TD(GraphicsState graphicState, Stack stack, TextMetrics textMetrics, PageText pageText, LinkedList<OptionalContents> oCGs) {
        float y = ((Number)stack.pop()).floatValue();
        float x = ((Number)stack.pop()).floatValue();
        graphicState.translate(-textMetrics.getShift(), 0.0);
        textMetrics.setShift(0.0f);
        textMetrics.setPreviousAdvance(0.0f);
        textMetrics.getAdvance().setLocation(0.0f, 0.0f);
        graphicState.translate(x, -y);
        graphicState.getTextState().leading = -y;
        if (textMetrics.isYstart()) {
            textMetrics.setyBTStart(y);
            textMetrics.setYstart(false);
        }
        if (y != 0.0f) {
            pageText.newLine(oCGs);
        }
    }

    protected static void consume_double_quote(GraphicsState graphicState, Stack stack, Shapes shapes, TextMetrics textMetrics, GlyphOutlineClip glyphOutlineClip, LinkedList<OptionalContents> oCGs) {
        StringObject stringObject = (StringObject)stack.pop();
        graphicState.getTextState().cspace = ((Number)stack.pop()).floatValue();
        graphicState.getTextState().wspace = ((Number)stack.pop()).floatValue();
        graphicState.translate(-textMetrics.getShift(), graphicState.getTextState().leading);
        AbstractContentParser.setAlpha(shapes, graphicState.getAlphaRule(), graphicState.getFillAlpha());
        textMetrics.setShift(0.0f);
        textMetrics.setPreviousAdvance(0.0f);
        textMetrics.getAdvance().setLocation(0.0f, 0.0f);
        TextState textState = graphicState.getTextState();
        AffineTransform tmp = AbstractContentParser.applyTextScaling(graphicState);
        AbstractContentParser.drawString(stringObject.getLiteralStringBuffer(textState.font.getSubTypeFormat(), textState.font.getFont()), textMetrics, graphicState.getTextState(), shapes, glyphOutlineClip, graphicState, oCGs);
        graphicState.set(tmp);
        graphicState.translate(textMetrics.getAdvance().x, 0.0);
        float shift = textMetrics.getShift();
        textMetrics.setShift(shift += textMetrics.getAdvance().x);
    }

    protected static void consume_single_quote(GraphicsState graphicState, Stack stack, Shapes shapes, TextMetrics textMetrics, GlyphOutlineClip glyphOutlineClip, LinkedList<OptionalContents> oCGs) {
        AbstractContentParser.consume_T_star(graphicState, textMetrics, shapes.getPageText(), oCGs);
        AbstractContentParser.consume_Tj(graphicState, stack, shapes, textMetrics, glyphOutlineClip, oCGs);
    }

    protected static void consume_Td(GraphicsState graphicState, Stack stack, TextMetrics textMetrics, PageText pageText, double previousBTStart, LinkedList<OptionalContents> oCGs) {
        float y = ((Number)stack.pop()).floatValue();
        float x = ((Number)stack.pop()).floatValue();
        double oldY = graphicState.getCTM().getTranslateY();
        graphicState.translate(-textMetrics.getShift(), 0.0);
        textMetrics.setShift(0.0f);
        textMetrics.setPreviousAdvance(0.0f);
        textMetrics.getAdvance().setLocation(0.0f, 0.0f);
        graphicState.translate(x, -y);
        float newY = (float)graphicState.getCTM().getTranslateY();
        if (textMetrics.isYstart()) {
            textMetrics.setyBTStart(newY);
            textMetrics.setYstart(false);
            if (previousBTStart != (double)textMetrics.getyBTStart()) {
                pageText.newLine(oCGs);
            }
        }
        if (y != 0.0f && (long)Math.round(newY) != Math.round(oldY)) {
            pageText.newLine(oCGs);
        }
    }

    protected static void consume_Tz(GraphicsState graphicState, Stack stack) {
        Object ob = stack.pop();
        if (ob instanceof Number) {
            float hScaling = ((Number)ob).floatValue();
            graphicState.getTextState().hScalling = hScaling / 100.0f;
        }
    }

    protected static void consume_Tw(GraphicsState graphicState, Stack stack) {
        graphicState.getTextState().wspace = ((Number)stack.pop()).floatValue();
    }

    protected static void consume_Tr(GraphicsState graphicState, Stack stack) {
        graphicState.getTextState().rmode = (int)((Number)stack.pop()).floatValue();
    }

    protected static void consume_TL(GraphicsState graphicState, Stack stack) {
        graphicState.getTextState().leading = ((Number)stack.pop()).floatValue();
    }

    protected static void consume_Ts(GraphicsState graphicState, Stack stack) {
        graphicState.getTextState().trise = ((Number)stack.pop()).floatValue();
    }

    protected static GeneralPath consume_L(Stack stack, GeneralPath geometricPath) {
        float y = ((Number)stack.pop()).floatValue();
        float x = ((Number)stack.pop()).floatValue();
        if (geometricPath == null) {
            geometricPath = new GeneralPath();
        }
        geometricPath.lineTo(x, y);
        return geometricPath;
    }

    protected static GeneralPath consume_m(Stack stack, GeneralPath geometricPath) {
        if (geometricPath == null) {
            geometricPath = new GeneralPath();
        }
        float y = ((Number)stack.pop()).floatValue();
        float x = ((Number)stack.pop()).floatValue();
        geometricPath.moveTo(x, y);
        return geometricPath;
    }

    protected static GeneralPath consume_c(Stack stack, GeneralPath geometricPath) {
        float y3 = ((Number)stack.pop()).floatValue();
        float x3 = ((Number)stack.pop()).floatValue();
        float y2 = ((Number)stack.pop()).floatValue();
        float x2 = ((Number)stack.pop()).floatValue();
        float y1 = ((Number)stack.pop()).floatValue();
        float x1 = ((Number)stack.pop()).floatValue();
        if (geometricPath == null) {
            geometricPath = new GeneralPath();
        }
        geometricPath.curveTo(x1, y1, x2, y2, x3, y3);
        return geometricPath;
    }

    protected static GeneralPath consume_S(GraphicsState graphicState, Shapes shapes, GeneralPath geometricPath) {
        if (geometricPath != null) {
            AbstractContentParser.commonStroke(graphicState, shapes, geometricPath);
            geometricPath = null;
        }
        return geometricPath;
    }

    protected static GeneralPath consume_F(GraphicsState graphicState, Shapes shapes, GeneralPath geometricPath) throws NoninvertibleTransformException {
        if (geometricPath != null) {
            geometricPath.setWindingRule(1);
            AbstractContentParser.commonFill(shapes, graphicState, geometricPath);
        }
        geometricPath = null;
        return geometricPath;
    }

    protected static GeneralPath consume_f(GraphicsState graphicState, Shapes shapes, GeneralPath geometricPath) throws NoninvertibleTransformException {
        if (geometricPath != null) {
            geometricPath.setWindingRule(1);
            AbstractContentParser.commonFill(shapes, graphicState, geometricPath);
        }
        geometricPath = null;
        return geometricPath;
    }

    protected static GeneralPath consume_re(Stack stack, GeneralPath geometricPath) {
        if (geometricPath == null) {
            geometricPath = new GeneralPath();
        }
        float h = ((Number)stack.pop()).floatValue();
        float w = ((Number)stack.pop()).floatValue();
        float y = ((Number)stack.pop()).floatValue();
        float x = ((Number)stack.pop()).floatValue();
        geometricPath.moveTo(x, y);
        geometricPath.lineTo(x + w, y);
        geometricPath.lineTo(x + w, y + h);
        geometricPath.lineTo(x, y + h);
        geometricPath.lineTo(x, y);
        return geometricPath;
    }

    protected static void consume_h(GeneralPath geometricPath) {
        if (geometricPath != null) {
            geometricPath.closePath();
        }
    }

    protected static void consume_BDC(Stack stack, Shapes shapes, LinkedList<OptionalContents> oCGs, Resources resources) {
        Object properties = stack.pop();
        Name tag = (Name)stack.pop();
        OptionalContents optionalContents = null;
        if (tag.equals(OptionalContent.OC_KEY) && properties instanceof Name && (optionalContents = resources.getPropertyEntry((Name)properties)) != null) {
            optionalContents.init();
            shapes.add(new OCGStartDrawCmd(optionalContents));
        }
        if (optionalContents == null) {
            Name tmp = OptionalContent.NONE_OC_FLAG;
            if (properties instanceof Name) {
                tmp = (Name)properties;
            }
            optionalContents = new OptionalContentGroup(tmp.getName(), true);
        }
        if (oCGs != null) {
            oCGs.add(optionalContents);
        }
    }

    protected static void consume_EMC(Shapes shapes, LinkedList<OptionalContents> oCGs) {
        OptionalContents optionalContents;
        if (oCGs != null && !oCGs.isEmpty() && (optionalContents = oCGs.removeLast()).isOCG()) {
            shapes.add(new OCGEndDrawCmd());
        }
    }

    protected static void consume_BMC(Stack stack, Shapes shapes, LinkedList<OptionalContents> oCGs, Resources resources) {
        Object properties = stack.pop();
        if (properties instanceof Name) {
            OptionalContents optionalContents = resources.getPropertyEntry((Name)properties);
            if (optionalContents != null) {
                optionalContents.init();
                shapes.add(new OCGStartDrawCmd(optionalContents));
            } else {
                Name tmp = (Name)properties;
                optionalContents = new OptionalContentGroup(tmp.getName(), true);
            }
            if (oCGs != null) {
                oCGs.add(optionalContents);
            }
        }
    }

    protected static GeneralPath consume_f_star(GraphicsState graphicState, Shapes shapes, GeneralPath geometricPath) throws NoninvertibleTransformException {
        if (geometricPath != null) {
            geometricPath.setWindingRule(0);
            AbstractContentParser.commonFill(shapes, graphicState, geometricPath);
        }
        geometricPath = null;
        return geometricPath;
    }

    protected static GeneralPath consume_b(GraphicsState graphicState, Shapes shapes, GeneralPath geometricPath) throws NoninvertibleTransformException {
        if (geometricPath != null) {
            geometricPath.setWindingRule(1);
            geometricPath.closePath();
            AbstractContentParser.commonFill(shapes, graphicState, geometricPath);
            AbstractContentParser.commonStroke(graphicState, shapes, geometricPath);
        }
        geometricPath = null;
        return geometricPath;
    }

    protected static GeneralPath consume_n(GeneralPath geometricPath) throws NoninvertibleTransformException {
        geometricPath = null;
        return geometricPath;
    }

    protected static void consume_W(GraphicsState graphicState, GeneralPath geometricPath) throws NoninvertibleTransformException {
        if (geometricPath != null) {
            geometricPath.setWindingRule(1);
            geometricPath.closePath();
            graphicState.setClip(geometricPath);
        }
    }

    protected static void consume_v(Stack stack, GeneralPath geometricPath) {
        float y3 = ((Number)stack.pop()).floatValue();
        float x3 = ((Number)stack.pop()).floatValue();
        float y2 = ((Number)stack.pop()).floatValue();
        float x2 = ((Number)stack.pop()).floatValue();
        geometricPath.curveTo((float)geometricPath.getCurrentPoint().getX(), (float)geometricPath.getCurrentPoint().getY(), x2, y2, x3, y3);
    }

    protected static void consume_y(Stack stack, GeneralPath geometricPath) {
        float y3 = ((Number)stack.pop()).floatValue();
        float x3 = ((Number)stack.pop()).floatValue();
        float y1 = ((Number)stack.pop()).floatValue();
        float x1 = ((Number)stack.pop()).floatValue();
        geometricPath.curveTo(x1, y1, x3, y3, x3, y3);
    }

    protected static GeneralPath consume_B(GraphicsState graphicState, Shapes shapes, GeneralPath geometricPath) throws NoninvertibleTransformException {
        if (geometricPath != null) {
            geometricPath.setWindingRule(1);
            AbstractContentParser.commonFill(shapes, graphicState, geometricPath);
            AbstractContentParser.commonStroke(graphicState, shapes, geometricPath);
        }
        geometricPath = null;
        return geometricPath;
    }

    protected static GraphicsState consume_d0(GraphicsState graphicState, Stack stack) {
        graphicState = graphicState.save();
        float y = ((Number)stack.pop()).floatValue();
        float x = ((Number)stack.pop()).floatValue();
        TextState textState = graphicState.getTextState();
        textState.setType3HorizontalDisplacement(new Point2D.Float(x, y));
        return graphicState;
    }

    protected static GeneralPath consume_s(GraphicsState graphicState, Shapes shapes, GeneralPath geometricPath) {
        if (geometricPath != null) {
            geometricPath.closePath();
            AbstractContentParser.commonStroke(graphicState, shapes, geometricPath);
            geometricPath = null;
        }
        return geometricPath;
    }

    protected static GeneralPath consume_b_star(GraphicsState graphicState, Shapes shapes, GeneralPath geometricPath) throws NoninvertibleTransformException {
        if (geometricPath != null) {
            geometricPath.setWindingRule(0);
            geometricPath.closePath();
            AbstractContentParser.commonStroke(graphicState, shapes, geometricPath);
            AbstractContentParser.commonFill(shapes, graphicState, geometricPath);
        }
        geometricPath = null;
        return geometricPath;
    }

    protected static GraphicsState consume_d1(GraphicsState graphicState, Stack stack) {
        graphicState = graphicState.save();
        float x2 = ((Number)stack.pop()).floatValue();
        float y2 = ((Number)stack.pop()).floatValue();
        float x1 = ((Number)stack.pop()).floatValue();
        float y1 = ((Number)stack.pop()).floatValue();
        float y = ((Number)stack.pop()).floatValue();
        float x = ((Number)stack.pop()).floatValue();
        TextState textState = graphicState.getTextState();
        textState.setType3HorizontalDisplacement(new Point2D.Float(x, y));
        textState.setType3BBox(new PRectangle(new Point2D.Float(x1, y1), new Point2D.Float(x2, y2)));
        return graphicState;
    }

    protected static GeneralPath consume_B_star(GraphicsState graphicState, Shapes shapes, GeneralPath geometricPath) throws NoninvertibleTransformException {
        if (geometricPath != null) {
            geometricPath.setWindingRule(0);
            AbstractContentParser.commonStroke(graphicState, shapes, geometricPath);
            AbstractContentParser.commonFill(shapes, graphicState, geometricPath);
        }
        geometricPath = null;
        return geometricPath;
    }

    public static void consume_W_star(GraphicsState graphicState, GeneralPath geometricPath) {
        if (geometricPath != null) {
            geometricPath.setWindingRule(0);
            geometricPath.closePath();
            graphicState.setClip(geometricPath);
        }
    }

    public static void consume_DP(Stack stack) {
        stack.pop();
        stack.pop();
    }

    public static void consume_MP(Stack stack) {
        stack.pop();
    }

    public static void consume_sh(GraphicsState graphicState, Stack stack, Shapes shapes, Resources resources) {
        Name patternName;
        ShadingPattern pattern;
        Object o = stack.peek();
        if (o instanceof Name && (pattern = resources.getShading(patternName = (Name)stack.pop())) != null) {
            pattern.init();
            if (graphicState.getSoftMask() != null) {
                AbstractContentParser.setAlpha(shapes, graphicState.getAlphaRule(), 0.5f);
            } else {
                AbstractContentParser.setAlpha(shapes, graphicState.getAlphaRule(), graphicState.getFillAlpha());
            }
            shapes.add(new PaintDrawCmd(pattern.getPaint()));
            shapes.add(new ShapeDrawCmd(graphicState.getClip()));
            shapes.add(new FillDrawCmd());
        }
    }

    protected static void consume_TJ(GraphicsState graphicState, Stack stack, Shapes shapes, TextMetrics textMetrics, GlyphOutlineClip glyphOutlineClip, LinkedList<OptionalContents> oCGs) {
        AffineTransform tmp = AbstractContentParser.applyTextScaling(graphicState);
        AbstractContentParser.setAlpha(shapes, graphicState.getAlphaRule(), graphicState.getFillAlpha());
        List v = (List)stack.pop();
        for (Object currentObject : v) {
            if (currentObject instanceof StringObject) {
                StringObject stringObject = (StringObject)currentObject;
                TextState textState = graphicState.getTextState();
                AbstractContentParser.drawString(stringObject.getLiteralStringBuffer(textState.font.getSubTypeFormat(), textState.font.getFont()), textMetrics, graphicState.getTextState(), shapes, glyphOutlineClip, graphicState, oCGs);
            } else if (currentObject instanceof Number) {
                Number f = (Number)currentObject;
                textMetrics.getAdvance().x -= f.floatValue() / 1000.0f * graphicState.getTextState().currentfont.getSize();
            }
            textMetrics.setPreviousAdvance(textMetrics.getAdvance().x);
        }
        graphicState.set(tmp);
    }

    protected static void consume_Tj(GraphicsState graphicState, Stack stack, Shapes shapes, TextMetrics textMetrics, GlyphOutlineClip glyphOutlineClip, LinkedList<OptionalContents> oCGs) {
        Object tjValue = stack.pop();
        if (tjValue instanceof StringObject) {
            StringObject stringObject = (StringObject)tjValue;
            TextState textState = graphicState.getTextState();
            AffineTransform tmp = AbstractContentParser.applyTextScaling(graphicState);
            AbstractContentParser.setAlpha(shapes, graphicState.getAlphaRule(), graphicState.getFillAlpha());
            AbstractContentParser.drawString(stringObject.getLiteralStringBuffer(textState.font.getSubTypeFormat(), textState.font.getFont()), textMetrics, graphicState.getTextState(), shapes, glyphOutlineClip, graphicState, oCGs);
            graphicState.set(tmp);
            graphicState.translate(textMetrics.getAdvance().x, 0.0);
            float shift = textMetrics.getShift();
            textMetrics.setShift(shift += textMetrics.getAdvance().x);
            textMetrics.setPreviousAdvance(0.0f);
            textMetrics.getAdvance().setLocation(0.0f, 0.0f);
        }
    }

    protected static void drawString(StringBuilder displayText, TextMetrics textMetrics, TextState textState, Shapes shapes, GlyphOutlineClip glyphOutlineClip, GraphicsState graphicState, LinkedList<OptionalContents> oCGs) {
        float advanceX = textMetrics.getAdvance().x;
        float advanceY = textMetrics.getAdvance().y;
        if (displayText.length() == 0) {
            textMetrics.getAdvance().setLocation(textMetrics.getPreviousAdvance(), 0.0f);
            return;
        }
        float lastx = 0.0f;
        float lasty = 0.0f;
        char currentChar = displayText.charAt(0);
        float firstCharWidth = (float)textState.currentfont.echarAdvance(currentChar).getX();
        if (advanceX + firstCharWidth < textMetrics.getPreviousAdvance()) {
            advanceX = textMetrics.getPreviousAdvance();
        }
        FontFile currentFont = textState.currentfont;
        boolean isVerticalWriting = textState.font.isVerticalWriting();
        float textRise = textState.trise;
        float characterSpace = textState.cspace * textState.hScalling;
        float whiteSpace = textState.wspace * textState.hScalling;
        int textLength = displayText.length();
        TextSprite textSprites = new TextSprite(currentFont, textLength, new AffineTransform(graphicState.getCTM()));
        for (int i = 0; i < textLength; ++i) {
            float currentY;
            float currentX;
            float newAdvanceX;
            currentChar = displayText.charAt(i);
            float newAdvanceY = newAdvanceX = (float)currentFont.echarAdvance(currentChar).getX();
            if (!isVerticalWriting) {
                currentX = advanceX + lastx;
                currentY = lasty - textRise;
                textMetrics.setPreviousAdvance(lastx += newAdvanceX);
                lastx += characterSpace;
                if (displayText.charAt(i) == ' ') {
                    lastx += whiteSpace;
                }
            } else {
                currentX = advanceX - newAdvanceX / 2.0f;
                currentY = advanceY + (lasty += newAdvanceY - textRise);
            }
            GlyphText glyphText = textSprites.addText(String.valueOf(currentChar), textState.currentfont.toUnicode(currentChar), currentX, currentY, newAdvanceX);
            shapes.getPageText().addGlyph(glyphText, oCGs);
        }
        advanceX += lastx;
        advanceY += lasty;
        int rmode = textState.rmode;
        switch (rmode) {
            case 0: {
                AbstractContentParser.drawModeFill(graphicState, textSprites, shapes, rmode);
                break;
            }
            case 1: {
                AbstractContentParser.drawModeStroke(graphicState, textSprites, textState, shapes, rmode);
                break;
            }
            case 2: {
                AbstractContentParser.drawModeFillStroke(graphicState, textSprites, textState, shapes, rmode);
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                AbstractContentParser.drawModeFill(graphicState, textSprites, shapes, rmode);
                glyphOutlineClip.addTextSprite(textSprites);
                break;
            }
            case 5: {
                AbstractContentParser.drawModeStroke(graphicState, textSprites, textState, shapes, rmode);
                glyphOutlineClip.addTextSprite(textSprites);
                break;
            }
            case 6: {
                AbstractContentParser.drawModeFillStroke(graphicState, textSprites, textState, shapes, rmode);
                glyphOutlineClip.addTextSprite(textSprites);
                break;
            }
            case 7: {
                glyphOutlineClip.addTextSprite(textSprites);
            }
        }
        textMetrics.getAdvance().setLocation(advanceX, advanceY);
    }

    protected static void drawModeFill(GraphicsState graphicState, TextSprite textSprites, Shapes shapes, int rmode) {
        textSprites.setRMode(rmode);
        textSprites.setStrokeColor(graphicState.getFillColor());
        shapes.add(new ColorDrawCmd(graphicState.getFillColor()));
        shapes.add(new TextSpriteDrawCmd(textSprites));
    }

    protected static void drawModeStroke(GraphicsState graphicState, TextSprite textSprites, TextState textState, Shapes shapes, int rmode) {
        textSprites.setRMode(rmode);
        textSprites.setStrokeColor(graphicState.getStrokeColor());
        float old = graphicState.getLineWidth();
        float lineWidth = graphicState.getLineWidth();
        lineWidth = (float)((double)lineWidth / textState.tmatrix.getScaleX());
        graphicState.setLineWidth(lineWidth);
        AbstractContentParser.setStroke(shapes, graphicState);
        shapes.add(new ColorDrawCmd(graphicState.getStrokeColor()));
        shapes.add(new TextSpriteDrawCmd(textSprites));
        graphicState.setLineWidth(old);
        AbstractContentParser.setStroke(shapes, graphicState);
    }

    protected static void drawModeFillStroke(GraphicsState graphicState, TextSprite textSprites, TextState textState, Shapes shapes, int rmode) {
        textSprites.setRMode(rmode);
        textSprites.setStrokeColor(graphicState.getStrokeColor());
        float old = graphicState.getLineWidth();
        float lineWidth = graphicState.getLineWidth();
        lineWidth = (float)((double)lineWidth / textState.tmatrix.getScaleX());
        graphicState.setLineWidth(lineWidth);
        AbstractContentParser.setStroke(shapes, graphicState);
        shapes.add(new ColorDrawCmd(graphicState.getFillColor()));
        shapes.add(new TextSpriteDrawCmd(textSprites));
        graphicState.setLineWidth(old);
        AbstractContentParser.setStroke(shapes, graphicState);
    }

    protected static void commonStroke(GraphicsState graphicState, Shapes shapes, GeneralPath geometricPath) {
        if (graphicState.isOverprintStroking()) {
            AbstractContentParser.setAlpha(shapes, graphicState.getAlphaRule(), AbstractContentParser.commonOverPrintAlpha(graphicState.getStrokeAlpha()));
        } else if (graphicState.isKnockOut()) {
            AbstractContentParser.setAlpha(shapes, 2, graphicState.getStrokeAlpha());
        }
        if (graphicState.getStrokeColorSpace() instanceof PatternColor) {
            PatternColor patternColor = (PatternColor)graphicState.getStrokeColorSpace();
            Pattern pattern = patternColor.getPattern();
            if (pattern != null && pattern.getPatternType() == 1) {
                TilingPattern tilingPattern = (TilingPattern)pattern;
                graphicState = graphicState.save();
                tilingPattern.setParentGraphicState(graphicState);
                tilingPattern.init();
                graphicState = graphicState.restore();
                if (tilingPattern.getbBoxMod() != null && (tilingPattern.getbBoxMod().getWidth() > 1.0 || tilingPattern.getbBoxMod().getHeight() > 1.0)) {
                    shapes.add(new TilingPatternDrawCmd(tilingPattern));
                } else if (tilingPattern.getPaintType() == 2) {
                    shapes.add(new ColorDrawCmd(tilingPattern.getUnColored()));
                } else {
                    shapes.add(new ColorDrawCmd(tilingPattern.getFirstColor()));
                }
                shapes.add(new ShapeDrawCmd(geometricPath));
                shapes.add(new DrawDrawCmd());
            } else if (pattern != null && pattern.getPatternType() == 2) {
                pattern.init();
                shapes.add(new PaintDrawCmd(pattern.getPaint()));
                shapes.add(new ShapeDrawCmd(geometricPath));
                shapes.add(new DrawDrawCmd());
            }
        } else {
            AbstractContentParser.setAlpha(shapes, graphicState.getAlphaRule(), graphicState.getStrokeAlpha());
            shapes.add(new ColorDrawCmd(graphicState.getStrokeColor()));
            shapes.add(new ShapeDrawCmd(geometricPath));
            shapes.add(new DrawDrawCmd());
        }
        if (graphicState.isOverprintStroking()) {
            AbstractContentParser.setAlpha(shapes, 3, graphicState.getFillAlpha());
        }
    }

    protected static float commonOverPrintAlpha(float alpha) {
        if (alpha != 1.0f && alpha > 0.4f) {
            alpha -= 0.4f;
        } else if (!(alpha < 0.4f)) {
            alpha = 0.4f;
        }
        return alpha;
    }

    protected static void commonFill(Shapes shapes, GraphicsState graphicState, GeneralPath geometricPath) throws NoninvertibleTransformException {
        if (graphicState.isOverprintOther()) {
            AbstractContentParser.setAlpha(shapes, graphicState.getAlphaRule(), AbstractContentParser.commonOverPrintAlpha(graphicState.getFillAlpha()));
        } else if (graphicState.isKnockOut()) {
            AbstractContentParser.setAlpha(shapes, 2, graphicState.getFillAlpha());
        } else {
            AbstractContentParser.setAlpha(shapes, graphicState.getAlphaRule(), graphicState.getFillAlpha());
        }
        if (graphicState.getFillColorSpace() instanceof PatternColor) {
            PatternColor patternColor = (PatternColor)graphicState.getFillColorSpace();
            Pattern pattern = patternColor.getPattern();
            if (pattern != null && pattern.getPatternType() == 1) {
                TilingPattern tilingPattern = (TilingPattern)pattern;
                graphicState = graphicState.save();
                tilingPattern.setParentGraphicState(graphicState);
                tilingPattern.init();
                graphicState = graphicState.restore();
                if (tilingPattern.getbBoxMod() != null && (tilingPattern.getbBoxMod().getWidth() >= 1.0 || tilingPattern.getbBoxMod().getHeight() >= 1.0)) {
                    shapes.add(new TilingPatternDrawCmd(tilingPattern));
                } else if (tilingPattern.getPaintType() == 2) {
                    shapes.add(new ColorDrawCmd(tilingPattern.getUnColored()));
                } else {
                    shapes.add(new ColorDrawCmd(tilingPattern.getFirstColor()));
                }
                shapes.add(new ShapeDrawCmd(geometricPath));
                shapes.add(new FillDrawCmd());
            } else if (pattern != null && pattern.getPatternType() == 2) {
                pattern.init();
                shapes.add(new PaintDrawCmd(pattern.getPaint()));
                shapes.add(new ShapeDrawCmd(geometricPath));
                shapes.add(new FillDrawCmd());
            }
        } else {
            shapes.add(new ColorDrawCmd(graphicState.getFillColor()));
            shapes.add(new ShapeDrawCmd(geometricPath));
            shapes.add(new FillDrawCmd());
        }
        if (graphicState.isOverprintOther()) {
            AbstractContentParser.setAlpha(shapes, graphicState.getAlphaRule(), graphicState.getFillAlpha());
        }
    }

    protected static void setStroke(Shapes shapes, GraphicsState graphicState) {
        shapes.add(new StrokeDrawCmd(new BasicStroke(graphicState.getLineWidth(), graphicState.getLineCap(), graphicState.getLineJoin(), graphicState.getMiterLimit(), graphicState.getDashArray(), graphicState.getDashPhase())));
    }

    protected static AffineTransform applyTextScaling(GraphicsState graphicState) {
        AffineTransform af = new AffineTransform(graphicState.getCTM());
        AffineTransform oldHScaling = new AffineTransform(graphicState.getCTM());
        float hScalling = graphicState.getTextState().hScalling;
        AffineTransform horizontalScalingTransform = new AffineTransform(af.getScaleX() * (double)hScalling, af.getShearY(), af.getShearX(), af.getScaleY(), af.getTranslateX(), af.getTranslateY());
        graphicState.set(horizontalScalingTransform);
        return oldHScaling;
    }

    protected static void setAlpha(Shapes shapes, int rule, float alpha) {
        AlphaComposite alphaComposite = AlphaComposite.getInstance(rule, alpha);
        shapes.add(new AlphaDrawCmd(alphaComposite));
    }
}

