/*
 * Decompiled with CFR 0.152.
 */
package de.muntjak.tinylookandfeel;

import de.muntjak.tinylookandfeel.MenuItemIconFactory;
import de.muntjak.tinylookandfeel.SpecialUIButton;
import de.muntjak.tinylookandfeel.Theme;
import de.muntjak.tinylookandfeel.TinyLookAndFeel;
import de.muntjak.tinylookandfeel.TinyMenuUI;
import de.muntjak.tinylookandfeel.TinyPopupFactory;
import de.muntjak.tinylookandfeel.TinyRootPaneUI;
import de.muntjak.tinylookandfeel.TinyWindowButtonUI;
import de.muntjak.tinylookandfeel.controlpanel.ControlPanel;
import de.muntjak.tinylookandfeel.util.ColorRoutines;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.UIResource;

public class TinyTitlePane
extends JComponent {
    private static final HashMap cache = new HashMap();
    public static Color buttonUpperColor;
    public static Color buttonLowerColor;
    private static final int IMAGE_HEIGHT = 16;
    private static final int IMAGE_WIDTH = 16;
    private static TinyWindowButtonUI iconButtonUI;
    private static TinyWindowButtonUI maxButtonUI;
    private static TinyWindowButtonUI closeButtonUI;
    private PropertyChangeListener propertyChangeListener;
    private JMenuBar menuBar;
    private Image systemIcon;
    private Action closeAction;
    private Action iconifyAction;
    private Action restoreAction;
    private Action maximizeAction;
    private JButton toggleButton;
    private JButton iconifyButton;
    private JButton closeButton;
    private WindowListener windowListener;
    private ComponentListener windowMoveListener;
    private Window window;
    private JRootPane rootPane;
    private int buttonsWidth;
    private int state;
    private TinyRootPaneUI rootPaneUI;

    public TinyTitlePane(JRootPane jRootPane, TinyRootPaneUI tinyRootPaneUI) {
        this.rootPane = jRootPane;
        this.rootPaneUI = tinyRootPaneUI;
        this.state = -1;
        this.installSubcomponents();
        this.installDefaults();
        this.setLayout(this.createLayout());
    }

    public static void clearCache() {
        cache.clear();
    }

    private void uninstall() {
        this.uninstallListeners();
        this.window = null;
        this.removeAll();
    }

    private void installListeners() {
        if (this.window != null) {
            this.windowListener = this.createWindowListener();
            this.window.addWindowListener(this.windowListener);
            this.propertyChangeListener = this.createWindowPropertyChangeListener();
            this.window.addPropertyChangeListener(this.propertyChangeListener);
            this.windowMoveListener = new WindowMoveListener();
            this.window.addComponentListener(this.windowMoveListener);
            if (this.window instanceof JDialog) {
                TinyPopupFactory.addDialog((JDialog)this.window);
            }
        }
    }

    private void uninstallListeners() {
        if (this.window != null) {
            this.window.removeWindowListener(this.windowListener);
            this.window.removePropertyChangeListener(this.propertyChangeListener);
            this.window.removeComponentListener(this.windowMoveListener);
        }
    }

    private WindowListener createWindowListener() {
        return new WindowHandler();
    }

    private PropertyChangeListener createWindowPropertyChangeListener() {
        return new PropertyChangeHandler();
    }

    public JRootPane getRootPane() {
        return this.rootPane;
    }

    private int getWindowDecorationStyle() {
        return this.getRootPane().getWindowDecorationStyle();
    }

    public void addNotify() {
        super.addNotify();
        this.uninstallListeners();
        this.window = SwingUtilities.getWindowAncestor(this);
        if (this.window != null) {
            if (this.window instanceof Frame) {
                this.setState(((Frame)this.window).getExtendedState());
            } else {
                this.setState(0);
            }
            this.setActive(this.window.isActive());
            this.installListeners();
            this.updateSystemIcon();
        }
    }

    public void removeNotify() {
        super.removeNotify();
        this.uninstallListeners();
        this.window = null;
    }

    private void installSubcomponents() {
        int n = this.getWindowDecorationStyle();
        if (n == 1) {
            this.createActions();
            this.menuBar = this.createMenuBar();
            this.add(this.menuBar);
            this.createButtons(n);
            this.add(this.iconifyButton);
            this.add(this.toggleButton);
            this.add(this.closeButton);
            this.iconifyButton.putClientProperty("externalFrameButton", Boolean.TRUE);
            this.toggleButton.putClientProperty("externalFrameButton", Boolean.TRUE);
            this.closeButton.putClientProperty("externalFrameButton", Boolean.TRUE);
        } else if (n == 2 || n == 5 || n == 6) {
            this.createActions();
            this.menuBar = this.createMenuBar();
            this.add(this.menuBar);
            this.createButtons(n);
            this.add(this.closeButton);
            this.closeButton.putClientProperty("externalFrameButton", Boolean.TRUE);
        } else if (n == 3 || n == 4 || n == 7 || n == 8) {
            this.createActions();
            this.createButtons(n);
            this.add(this.closeButton);
            this.closeButton.putClientProperty("externalFrameButton", Boolean.TRUE);
        }
    }

    private void installDefaults() {
        this.setFont(UIManager.getFont("Frame.titleFont", this.getLocale()));
    }

    private void uninstallDefaults() {
    }

    protected JMenuBar createMenuBar() {
        this.menuBar = new SystemMenuBar();
        this.menuBar.setFocusable(false);
        this.menuBar.setBorderPainted(true);
        this.menuBar.add(this.createMenu());
        return this.menuBar;
    }

    private void updateSystemIcon() {
        this.systemIcon = this.getWindowIcon(this.getWindow());
    }

    private Image getWindowIcon(Window window) {
        if (window == null) {
            return null;
        }
        if (window instanceof Frame) {
            return ((Frame)window).getIconImage();
        }
        try {
            Method method = window.getClass().getMethod("getIconImages", null);
            List list = (List)method.invoke((Object)window, (Object[])null);
            if (list != null) {
                if (list.size() == 0) {
                    return this.getWindowIcon(window.getOwner());
                }
                if (list.size() == 1) {
                    return (Image)list.get(0);
                }
                for (int i = 0; i < list.size(); ++i) {
                    Image image = (Image)list.get(i);
                    if (image.getWidth(this) != 16 || image.getHeight(this) != 16) continue;
                    return image;
                }
                return ((Image)list.get(0)).getScaledInstance(16, 16, 4);
            }
        }
        catch (Exception exception) {
            return this.getWindowIcon(window.getOwner());
        }
        return null;
    }

    private void close() {
        Window window = this.getWindow();
        if (window != null) {
            window.dispatchEvent(new WindowEvent(window, 201));
        }
    }

    private void iconify() {
        Frame frame = this.getFrame();
        if (frame != null) {
            frame.setExtendedState(frame.getExtendedState() | 1);
        }
    }

    private void maximize() {
        Frame frame = this.getFrame();
        if (frame != null) {
            this.setMaximizeBounds(frame);
            frame.setExtendedState(frame.getExtendedState() | 6);
        }
    }

    protected void setMaximizeBounds(Frame frame) {
        Insets insets = Toolkit.getDefaultToolkit().getScreenInsets(this.getGraphicsConfiguration());
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n = dimension.width - insets.left - insets.right;
        int n2 = dimension.height - insets.top - insets.bottom;
        Rectangle rectangle = new Rectangle(insets.left, insets.top, n, n2);
        frame.setMaximizedBounds(rectangle);
    }

    private void restore() {
        Frame frame = this.getFrame();
        if (frame == null) {
            return;
        }
        if ((frame.getExtendedState() & 1) == 1) {
            frame.setExtendedState(this.state & 0xFFFFFFFE);
        } else {
            frame.setExtendedState(this.state & 0xFFFFFFF9);
        }
    }

    private void createActions() {
        this.closeAction = new CloseAction();
        this.iconifyAction = new IconifyAction();
        this.restoreAction = new RestoreAction();
        this.maximizeAction = new MaximizeAction();
    }

    private JMenu createMenu() {
        JMenu jMenu = new JMenu("");
        jMenu.addMenuListener(new MenuListener(){

            public void menuSelected(MenuEvent menuEvent) {
                if (TinyTitlePane.this.windowHasMenuBar()) {
                    TinyMenuUI.systemMenuShowing = true;
                }
            }

            public void menuDeselected(MenuEvent menuEvent) {
                TinyMenuUI.systemMenuShowing = false;
            }

            public void menuCanceled(MenuEvent menuEvent) {
            }
        });
        if (this.getWindowDecorationStyle() == 1) {
            this.addSystemMenuItems(jMenu, true);
            jMenu.putClientProperty("isSystemMenu", Boolean.TRUE);
        } else if (this.getWindowDecorationStyle() != 0) {
            this.addSystemMenuItems(jMenu, false);
            jMenu.putClientProperty("isSystemMenu", Boolean.TRUE);
        }
        return jMenu;
    }

    private boolean windowHasMenuBar() {
        Window window = this.getWindow();
        if (window instanceof JFrame) {
            return ((JFrame)window).getJMenuBar() != null;
        }
        if (window instanceof JDialog) {
            return ((JDialog)window).getJMenuBar() != null;
        }
        return false;
    }

    private void addSystemMenuItems(JMenu jMenu, boolean bl) {
        int n;
        Locale locale = this.getRootPane().getLocale();
        JMenuItem jMenuItem = null;
        if (bl) {
            jMenuItem = jMenu.add(this.restoreAction);
            jMenuItem.setIcon(MenuItemIconFactory.getSystemRestoreIcon());
            n = this.getInt("MetalTitlePane.restoreMnemonic", -1);
            if (n != -1) {
                jMenuItem.setMnemonic(n);
            }
            jMenuItem = jMenu.add(this.iconifyAction);
            jMenuItem.setIcon(MenuItemIconFactory.getSystemIconifyIcon());
            n = this.getInt("MetalTitlePane.iconifyMnemonic", -1);
            if (n != -1) {
                jMenuItem.setMnemonic(n);
            }
            if (Toolkit.getDefaultToolkit().isFrameStateSupported(6)) {
                jMenuItem = jMenu.add(this.maximizeAction);
                jMenuItem.setIcon(MenuItemIconFactory.getSystemMaximizeIcon());
                n = this.getInt("MetalTitlePane.maximizeMnemonic", -1);
                if (n != -1) {
                    jMenuItem.setMnemonic(n);
                }
            }
            jMenu.addSeparator();
        }
        jMenuItem = jMenu.add(this.closeAction);
        jMenuItem.setIcon(MenuItemIconFactory.getSystemCloseIcon());
        n = this.getInt("MetalTitlePane.closeMnemonic", -1);
        if (n != -1) {
            jMenuItem.setMnemonic(n);
        }
    }

    protected void createButtons(int n) {
        if (iconButtonUI == null) {
            iconButtonUI = TinyWindowButtonUI.createButtonUIForType(2);
            maxButtonUI = TinyWindowButtonUI.createButtonUIForType(1);
            closeButtonUI = TinyWindowButtonUI.createButtonUIForType(0);
        }
        this.iconifyButton = new SpecialUIButton(iconButtonUI);
        this.iconifyButton.setAction(this.iconifyAction);
        this.iconifyButton.setText(null);
        this.iconifyButton.setRolloverEnabled(true);
        this.toggleButton = new SpecialUIButton(maxButtonUI);
        this.toggleButton.setAction(this.maximizeAction);
        this.toggleButton.setText(null);
        this.toggleButton.setRolloverEnabled(true);
        this.closeButton = new SpecialUIButton(closeButtonUI);
        this.closeButton.setAction(this.closeAction);
        this.closeButton.setText(null);
        this.closeButton.setRolloverEnabled(true);
        this.closeButton.getAccessibleContext().setAccessibleName("Close");
        this.iconifyButton.getAccessibleContext().setAccessibleName("Iconify");
        this.toggleButton.getAccessibleContext().setAccessibleName("Maximize");
        if (TinyLookAndFeel.controlPanelInstantiated && n == 1) {
            ControlPanel.setWindowButtons((JButton[])new JButton[]{this.iconifyButton, this.toggleButton, this.closeButton});
        }
    }

    private LayoutManager createLayout() {
        return new TitlePaneLayout();
    }

    private void setActive(boolean bl) {
        if (this.getWindowDecorationStyle() == 1) {
            Boolean bl2 = bl ? Boolean.TRUE : Boolean.FALSE;
            this.iconifyButton.putClientProperty("paintActive", bl2);
            this.closeButton.putClientProperty("paintActive", bl2);
            this.toggleButton.putClientProperty("paintActive", bl2);
            this.iconifyButton.setEnabled(bl);
            this.closeButton.setEnabled(bl);
            this.toggleButton.setEnabled(bl);
        }
        this.getRootPane().repaint();
    }

    private void setState(int n) {
        this.setState(n, false);
    }

    private void setState(int n, boolean bl) {
        Window window = this.getWindow();
        if (window != null && this.getWindowDecorationStyle() == 1) {
            if (this.state == n && !bl) {
                return;
            }
            Frame frame = this.getFrame();
            if (frame != null) {
                JRootPane jRootPane = this.getRootPane();
                if ((n & 6) == 6 && (jRootPane.getBorder() == null || jRootPane.getBorder() instanceof UIResource) && frame.isShowing() || (n & 6) != 6) {
                    // empty if block
                }
                if (frame.isResizable()) {
                    if ((n & 4) == 4 || (n & 2) == 2) {
                        this.updateToggleButton(this.restoreAction);
                        this.maximizeAction.setEnabled(false);
                        this.restoreAction.setEnabled(true);
                    } else {
                        this.updateToggleButton(this.maximizeAction);
                        this.maximizeAction.setEnabled(true);
                        this.restoreAction.setEnabled(false);
                    }
                    if (this.toggleButton.getParent() == null || this.iconifyButton.getParent() == null) {
                        this.add(this.toggleButton);
                        this.add(this.iconifyButton);
                        this.revalidate();
                        this.repaint();
                    }
                    this.toggleButton.setText(null);
                } else {
                    this.maximizeAction.setEnabled(false);
                    this.restoreAction.setEnabled(false);
                    if (this.toggleButton.getParent() != null) {
                        this.remove(this.toggleButton);
                        this.revalidate();
                        this.repaint();
                    }
                }
            } else {
                this.maximizeAction.setEnabled(false);
                this.restoreAction.setEnabled(false);
                this.iconifyAction.setEnabled(false);
                this.remove(this.toggleButton);
                this.remove(this.iconifyButton);
                this.revalidate();
                this.repaint();
            }
            this.closeAction.setEnabled(true);
            this.state = n;
        }
    }

    private void updateToggleButton(Action action) {
        this.toggleButton.setAction(action);
        this.toggleButton.setText(null);
    }

    private Frame getFrame() {
        Window window = this.getWindow();
        if (window instanceof Frame) {
            return (Frame)window;
        }
        return null;
    }

    private Window getWindow() {
        return this.window;
    }

    private String getTitle() {
        Window window = this.getWindow();
        if (window instanceof Frame) {
            return ((Frame)window).getTitle();
        }
        if (window instanceof Dialog) {
            return ((Dialog)window).getTitle();
        }
        return null;
    }

    public boolean isSelected() {
        Window window = this.getWindow();
        return window == null ? true : window.isActive();
    }

    public boolean isFrameMaximized() {
        Frame frame = this.getFrame();
        if (frame != null) {
            return (frame.getExtendedState() & 6) == 6;
        }
        return false;
    }

    public void paintComponent(Graphics graphics) {
        String string;
        Window window;
        if (this.getFrame() != null) {
            this.setState(this.getFrame().getExtendedState());
        }
        boolean bl = (window = this.getWindow()) == null ? this.getRootPane().getComponentOrientation().isLeftToRight() : window.getComponentOrientation().isLeftToRight();
        boolean bl2 = window == null ? true : window.isActive();
        int n = this.getWidth();
        int n2 = this.getHeight();
        int n3 = bl ? 5 : n - 5;
        this.paintCaption(graphics, n, n2, bl2, 29, window);
        int n4 = this.getWindowDecorationStyle();
        if (n4 == 1 || n4 == 2 || n4 == 5 || n4 == 6) {
            n3 += bl ? 21 : -21;
        }
        if ((string = this.getTitle()) != null) {
            FontMetrics fontMetrics = graphics.getFontMetrics();
            int n5 = n2 == 29 ? 2 : 0;
            int n6 = (n2 - fontMetrics.getHeight()) / 2 + fontMetrics.getAscent() + n5;
            Rectangle rectangle = new Rectangle(0, 0, 0, 0);
            if (this.iconifyButton != null && this.iconifyButton.getParent() != null) {
                rectangle = this.iconifyButton.getBounds();
            }
            if (bl) {
                if (rectangle.x == 0) {
                    rectangle.x = window.getWidth() - window.getInsets().right - 2;
                }
                int n7 = rectangle.x - n3 - 4;
                string = this.clippedText(string, fontMetrics, n7);
            } else {
                int n8 = n3 - rectangle.x - rectangle.width - 4;
                string = this.clippedText(string, fontMetrics, n8);
                n3 -= SwingUtilities.computeStringWidth(fontMetrics, string);
            }
            int n9 = SwingUtilities.computeStringWidth(fontMetrics, string);
            if (graphics instanceof Graphics2D) {
                Graphics2D graphics2D = (Graphics2D)graphics;
                graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            }
            if (bl2) {
                graphics.setColor(Theme.frameTitleShadowColor.getColor());
                graphics.drawString(string, n3 + 1, n6 + 1);
                graphics.setColor(Theme.frameTitleColor.getColor());
                graphics.drawString(string, n3, n6);
            } else {
                graphics.setColor(Theme.frameTitleDisabledColor.getColor());
                graphics.drawString(string, n3, n6);
            }
        }
    }

    private void paintCaption(Graphics graphics, int n, int n2, boolean bl, int n3, Window window) {
        if (TinyLookAndFeel.controlPanelInstantiated) {
            this.paintXPCaptionNoCache(graphics, n, n2, bl, n3, window);
        } else {
            this.paintXPCaption(graphics, n, n2, bl, n3, window);
        }
    }

    private void paintXPCaption(Graphics graphics, int n, int n2, boolean bl, int n3, Window window) {
        ColorUIResource colorUIResource = null;
        colorUIResource = bl ? Theme.frameCaptionColor.getColor() : Theme.frameCaptionDisabledColor.getColor();
        graphics.setColor(colorUIResource);
        int n4 = 0;
        int n5 = 0;
        int n6 = Theme.frameSpreadDarkDisabled.getValue();
        int n7 = Theme.frameSpreadLightDisabled.getValue();
        int n8 = n5;
        ColorUIResource colorUIResource2 = null;
        if (bl) {
            colorUIResource2 = Theme.frameBorderColor.getColor();
            n6 = Theme.frameSpreadDark.getValue();
            n7 = Theme.frameSpreadLight.getValue();
        } else {
            colorUIResource2 = Theme.frameBorderDisabledColor.getColor();
        }
        graphics.setColor(ColorRoutines.getAlphaColor(colorUIResource2, 82));
        graphics.drawLine(n4, n8, n4, n8);
        graphics.drawLine(n4 + n - 1, n8, n4 + n - 1, n8);
        graphics.setColor(ColorRoutines.getAlphaColor(colorUIResource2, 156));
        graphics.drawLine(n4 + 1, n8, n4 + 1, n8);
        graphics.drawLine(n4 + n - 2, n8, n4 + n - 2, n8);
        graphics.setColor(ColorRoutines.getAlphaColor(colorUIResource2, 215));
        graphics.drawLine(n4 + 2, n8, n4 + 2, n8);
        graphics.drawLine(n4 + n - 3, n8, n4 + n - 3, n8);
        Color color = ColorRoutines.darken(colorUIResource, 4 * n6);
        graphics.setColor(color);
        graphics.drawLine(n4, ++n8, n4 + 2, n8);
        graphics.drawLine(n4 + n - 3, n8, n4 + n - 1, n8);
        graphics.setColor(ColorRoutines.lighten(colorUIResource, 10 * n7));
        graphics.drawLine(n4 + 1, ++n8, n4 + 2, n8);
        graphics.drawLine(n4 + n - 3, n8, n4 + n - 1, n8);
        graphics.setColor(colorUIResource);
        graphics.drawLine(n4, n8, n4, n8);
        graphics.drawLine(n4 + n - 1, n8, n4 + n - 1, n8);
        graphics.setColor(ColorRoutines.lighten(colorUIResource, 10 * n7));
        graphics.drawLine(n4, ++n8, n4, n8);
        graphics.drawLine(n4 + n - 1, n8, n4 + n - 1, n8);
        graphics.setColor(ColorRoutines.lighten(colorUIResource, 7 * n7));
        graphics.drawLine(n4 + 1, n8, n4 + 1, n8);
        graphics.drawLine(n4 + n - 2, n8, n4 + n - 2, n8);
        graphics.setColor(ColorRoutines.lighten(colorUIResource, 3 * n7));
        graphics.drawLine(n4 + 2, n8, n4 + 2, n8);
        graphics.drawLine(n4 + n - 3, n8, n4 + n - 3, n8);
        graphics.setColor(ColorRoutines.darken(colorUIResource, 2 * n6));
        graphics.drawLine(n4 + 2, ++n8, n4 + 2, n8);
        graphics.drawLine(n4 + n4 + n - 3, n8, n4 + n - 3, n8);
        graphics.setColor(ColorRoutines.lighten(colorUIResource, 5 * n7));
        graphics.drawLine(n4, n8, n4, n8);
        graphics.drawLine(n4 + n - 1, n8, n4 + n - 1, n8);
        graphics.setColor(colorUIResource);
        graphics.drawLine(n4 + 1, n8, n4 + 1, n8);
        graphics.drawLine(n4 + n - 2, n8, n4 + n - 2, n8);
        ++n8;
        CaptionKey captionKey = new CaptionKey(Theme.frameCaptionColor.getColor(), bl, n3);
        Object v = cache.get(captionKey);
        if (v != null) {
            graphics.drawImage((Image)v, n4 + 3, n5, n4 + n - 3, n5 + 5, 0, 0, 1, 5, window);
            graphics.drawImage((Image)v, n4, n5 + 5, n4 + n, n5 + n3, 0, 5, 1, n3, window);
            buttonUpperColor = ColorRoutines.darken(colorUIResource, 4 * n6);
            buttonLowerColor = ColorRoutines.lighten(colorUIResource, 10 * n7);
            return;
        }
        BufferedImage bufferedImage = new BufferedImage(1, n3, 2);
        Graphics graphics2 = ((Image)bufferedImage).getGraphics();
        graphics2.setColor(colorUIResource2);
        graphics2.drawLine(0, 0, 1, 0);
        graphics2.setColor(ColorRoutines.darken(colorUIResource, 4 * n6));
        graphics2.drawLine(0, 1, 1, 1);
        graphics2.setColor(ColorRoutines.lighten(colorUIResource, 10 * n7));
        graphics2.drawLine(0, 2, 1, 2);
        graphics2.setColor(colorUIResource);
        graphics2.drawLine(0, 3, 1, 3);
        graphics2.setColor(ColorRoutines.darken(colorUIResource, 2 * n6));
        graphics2.drawLine(0, 4, 1, 4);
        buttonUpperColor = ColorRoutines.darken(colorUIResource, 4 * n6);
        graphics2.setColor(buttonUpperColor);
        graphics2.drawLine(0, 5, 1, 5);
        graphics2.setColor(ColorRoutines.darken(colorUIResource, 4 * n6));
        graphics2.drawLine(0, 6, 1, 6);
        graphics2.drawLine(0, 7, 1, 7);
        graphics2.setColor(ColorRoutines.darken(colorUIResource, 3 * n6));
        graphics2.drawLine(0, 8, 1, 8);
        graphics2.drawLine(0, 9, 1, 9);
        graphics2.drawLine(0, 10, 1, 10);
        graphics2.drawLine(0, 11, 1, 11);
        graphics2.setColor(ColorRoutines.darken(colorUIResource, 2 * n6));
        graphics2.drawLine(0, 12, 1, 12);
        graphics2.drawLine(0, 13, 1, 13);
        graphics2.drawLine(0, 14, 1, 14);
        graphics2.setColor(ColorRoutines.darken(colorUIResource, n6));
        graphics2.drawLine(0, 15, 1, 15);
        graphics2.drawLine(0, 16, 1, 16);
        graphics2.setColor(colorUIResource);
        graphics2.drawLine(0, 17, 1, 17);
        graphics2.drawLine(0, 18, 1, 18);
        graphics2.setColor(ColorRoutines.lighten(colorUIResource, 2 * n7));
        graphics2.drawLine(0, 19, 1, 19);
        graphics2.setColor(ColorRoutines.lighten(colorUIResource, 4 * n7));
        graphics2.drawLine(0, 20, 1, 20);
        graphics2.setColor(ColorRoutines.lighten(colorUIResource, 5 * n7));
        graphics2.drawLine(0, 21, 1, 21);
        graphics2.setColor(ColorRoutines.lighten(colorUIResource, 6 * n7));
        graphics2.drawLine(0, 22, 1, 22);
        graphics2.setColor(ColorRoutines.lighten(colorUIResource, 8 * n7));
        graphics2.drawLine(0, 23, 1, 23);
        graphics2.setColor(ColorRoutines.lighten(colorUIResource, 9 * n7));
        graphics2.drawLine(0, 24, 1, 24);
        buttonLowerColor = ColorRoutines.lighten(colorUIResource, 10 * n7);
        graphics2.setColor(buttonLowerColor);
        graphics2.drawLine(0, 25, 1, 25);
        graphics2.setColor(ColorRoutines.lighten(colorUIResource, 4 * n7));
        graphics2.drawLine(0, 26, 1, 26);
        graphics2.setColor(ColorRoutines.darken(colorUIResource, 2 * n6));
        graphics2.drawLine(0, 27, 1, 27);
        if (bl) {
            graphics2.setColor(Theme.frameLightColor.getColor());
        } else {
            graphics2.setColor(Theme.frameLightDisabledColor.getColor());
        }
        graphics2.drawLine(0, 28, 1, 28);
        graphics2.dispose();
        graphics.drawImage(bufferedImage, n4 + 3, n5, n4 + n - 3, n5 + 5, 0, 0, 1, 5, window);
        graphics.drawImage(bufferedImage, n4, n5 + 5, n4 + n, n5 + n3, 0, 5, 1, n3, window);
        cache.put(captionKey, bufferedImage);
    }

    private void paintXPCaptionNoCache(Graphics graphics, int n, int n2, boolean bl, int n3, Window window) {
        ColorUIResource colorUIResource = null;
        colorUIResource = bl ? Theme.frameCaptionColor.getColor() : Theme.frameCaptionDisabledColor.getColor();
        graphics.setColor(colorUIResource);
        int n4 = 0;
        int n5 = 0;
        int n6 = Theme.frameSpreadDarkDisabled.getValue();
        int n7 = Theme.frameSpreadLightDisabled.getValue();
        int n8 = n5;
        ColorUIResource colorUIResource2 = null;
        if (bl) {
            colorUIResource2 = Theme.frameBorderColor.getColor();
            n6 = Theme.frameSpreadDark.getValue();
            n7 = Theme.frameSpreadLight.getValue();
        } else {
            colorUIResource2 = Theme.frameBorderDisabledColor.getColor();
        }
        graphics.setColor(ColorRoutines.getAlphaColor(colorUIResource2, 82));
        graphics.drawLine(n4, n8, n4, n8);
        graphics.drawLine(n4 + n - 1, n8, n4 + n - 1, n8);
        graphics.setColor(ColorRoutines.getAlphaColor(colorUIResource2, 156));
        graphics.drawLine(n4 + 1, n8, n4 + 1, n8);
        graphics.drawLine(n4 + n - 2, n8, n4 + n - 2, n8);
        graphics.setColor(ColorRoutines.getAlphaColor(colorUIResource2, 215));
        graphics.drawLine(n4 + 2, n8, n4 + 2, n8);
        graphics.drawLine(n4 + n - 3, n8, n4 + n - 3, n8);
        Color color = ColorRoutines.darken(colorUIResource, 4 * n6);
        graphics.setColor(color);
        graphics.drawLine(n4, ++n8, n4 + 2, n8);
        graphics.drawLine(n4 + n - 3, n8, n4 + n - 1, n8);
        graphics.setColor(ColorRoutines.lighten(colorUIResource, 10 * n7));
        graphics.drawLine(n4 + 1, ++n8, n4 + 2, n8);
        graphics.drawLine(n4 + n - 3, n8, n4 + n - 1, n8);
        graphics.setColor(colorUIResource);
        graphics.drawLine(n4, n8, n4, n8);
        graphics.drawLine(n4 + n - 1, n8, n4 + n - 1, n8);
        graphics.setColor(ColorRoutines.lighten(colorUIResource, 10 * n7));
        graphics.drawLine(n4, ++n8, n4, n8);
        graphics.drawLine(n4 + n - 1, n8, n4 + n - 1, n8);
        graphics.setColor(ColorRoutines.lighten(colorUIResource, 7 * n7));
        graphics.drawLine(n4 + 1, n8, n4 + 1, n8);
        graphics.drawLine(n4 + n - 2, n8, n4 + n - 2, n8);
        graphics.setColor(ColorRoutines.lighten(colorUIResource, 3 * n7));
        graphics.drawLine(n4 + 2, n8, n4 + 2, n8);
        graphics.drawLine(n4 + n - 3, n8, n4 + n - 3, n8);
        graphics.setColor(ColorRoutines.darken(colorUIResource, 2 * n6));
        graphics.drawLine(n4 + 2, ++n8, n4 + 2, n8);
        graphics.drawLine(n4 + n4 + n - 3, n8, n4 + n - 3, n8);
        graphics.setColor(ColorRoutines.lighten(colorUIResource, 5 * n7));
        graphics.drawLine(n4, n8, n4, n8);
        graphics.drawLine(n4 + n - 1, n8, n4 + n - 1, n8);
        graphics.setColor(colorUIResource);
        graphics.drawLine(n4 + 1, n8, n4 + 1, n8);
        graphics.drawLine(n4 + n - 2, n8, n4 + n - 2, n8);
        n8 = n5;
        graphics.setColor(colorUIResource2);
        graphics.drawLine(n4 + 3, n8, n4 + n - 4, n8);
        graphics.setColor(ColorRoutines.darken(colorUIResource, 4 * n6));
        graphics.drawLine(n4 + 3, ++n8, n4 + n - 4, n8);
        graphics.setColor(ColorRoutines.lighten(colorUIResource, 10 * n7));
        graphics.drawLine(n4 + 3, ++n8, n4 + n - 4, n8);
        graphics.setColor(colorUIResource);
        graphics.drawLine(n4 + 3, ++n8, n4 + n - 4, n8);
        graphics.setColor(ColorRoutines.darken(colorUIResource, 2 * n6));
        graphics.drawLine(n4 + 3, ++n8, n4 + n - 4, n8);
        buttonUpperColor = ColorRoutines.darken(colorUIResource, 4 * n6);
        graphics.setColor(buttonUpperColor);
        graphics.drawLine(n4, ++n8, n4 + n - 1, n8);
        graphics.setColor(ColorRoutines.darken(colorUIResource, 4 * n6));
        graphics.fillRect(n4, ++n8, n4 + n, 2);
        graphics.setColor(ColorRoutines.darken(colorUIResource, 3 * n6));
        graphics.fillRect(n4, n8 += 2, n4 + n, 4);
        graphics.setColor(ColorRoutines.darken(colorUIResource, 2 * n6));
        graphics.fillRect(n4, n8 += 4, n4 + n, 3);
        graphics.setColor(ColorRoutines.darken(colorUIResource, 1 * n6));
        graphics.fillRect(n4, n8 += 3, n4 + n, 2);
        graphics.setColor(colorUIResource);
        graphics.fillRect(n4, n8 += 2, n4 + n, 2);
        graphics.setColor(ColorRoutines.lighten(colorUIResource, 2 * n7));
        graphics.drawLine(n4, n8 += 2, n4 + n - 1, n8);
        graphics.setColor(ColorRoutines.lighten(colorUIResource, 4 * n7));
        graphics.drawLine(n4, ++n8, n4 + n - 1, n8);
        graphics.setColor(ColorRoutines.lighten(colorUIResource, 5 * n7));
        graphics.drawLine(n4, ++n8, n4 + n - 1, n8);
        graphics.setColor(ColorRoutines.lighten(colorUIResource, 6 * n7));
        graphics.drawLine(n4, ++n8, n4 + n - 1, n8);
        graphics.setColor(ColorRoutines.lighten(colorUIResource, 8 * n7));
        graphics.drawLine(n4, ++n8, n4 + n - 1, n8);
        graphics.setColor(ColorRoutines.lighten(colorUIResource, 9 * n7));
        graphics.drawLine(n4, ++n8, n4 + n - 1, n8);
        buttonLowerColor = ColorRoutines.lighten(colorUIResource, 10 * n7);
        graphics.setColor(buttonLowerColor);
        graphics.drawLine(n4, ++n8, n4 + n - 1, n8);
        graphics.setColor(ColorRoutines.lighten(colorUIResource, 4 * n7));
        graphics.drawLine(n4, ++n8, n4 + n - 1, n8);
        graphics.setColor(ColorRoutines.darken(colorUIResource, 2 * n6));
        graphics.drawLine(n4, ++n8, n4 + n - 1, n8);
        ++n8;
        if (bl) {
            graphics.setColor(Theme.frameLightColor.getColor());
        } else {
            graphics.setColor(Theme.frameLightDisabledColor.getColor());
        }
        graphics.drawLine(n4, n8, n4 + n - 1, n8);
    }

    private String clippedText(String string, FontMetrics fontMetrics, int n) {
        if (string == null || string.equals("")) {
            return "";
        }
        int n2 = SwingUtilities.computeStringWidth(fontMetrics, string);
        String string2 = "...";
        if (n2 > n) {
            int n3;
            int n4 = SwingUtilities.computeStringWidth(fontMetrics, string2);
            for (n3 = 0; n3 < string.length() && (n4 += fontMetrics.charWidth(string.charAt(n3))) <= n; ++n3) {
            }
            string = string.substring(0, n3) + string2;
        }
        return string;
    }

    private int getInt(Object object, int n) {
        Object object2 = UIManager.get(object);
        if (object2 instanceof Integer) {
            return (Integer)object2;
        }
        if (object2 instanceof String) {
            try {
                return Integer.parseInt((String)object2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return n;
    }

    private static class CaptionKey {
        private Color frameCaptionColor;
        private boolean isActive;
        private int titleHeight;

        CaptionKey(Color color, boolean bl, int n) {
            this.frameCaptionColor = color;
            this.isActive = bl;
            this.titleHeight = n;
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (!(object instanceof CaptionKey)) {
                return false;
            }
            CaptionKey captionKey = (CaptionKey)object;
            return this.frameCaptionColor.equals(captionKey.frameCaptionColor) && this.isActive == captionKey.isActive && this.titleHeight == captionKey.titleHeight;
        }

        public int hashCode() {
            return this.frameCaptionColor.hashCode() * (this.isActive ? 1 : 2) * this.titleHeight;
        }
    }

    class WindowMoveListener
    extends ComponentAdapter {
        WindowMoveListener() {
        }

        public void componentMoved(ComponentEvent componentEvent) {
            if (TinyTitlePane.this.getWindowDecorationStyle() == 0) {
                return;
            }
            Window window = TinyTitlePane.this.getWindow();
            if (!window.isShowing()) {
                return;
            }
            window.repaint(0, 0, window.getWidth(), 5);
        }

        public void componentResized(ComponentEvent componentEvent) {
            if (TinyTitlePane.this.getWindowDecorationStyle() == 0) {
                return;
            }
            Window window = TinyTitlePane.this.getWindow();
            if (!window.isShowing()) {
                return;
            }
            window.repaint(0, 0, window.getWidth(), 5);
        }
    }

    private class WindowHandler
    extends WindowAdapter {
        private WindowHandler() {
        }

        public void windowActivated(WindowEvent windowEvent) {
            TinyTitlePane.this.setActive(true);
        }

        public void windowDeactivated(WindowEvent windowEvent) {
            TinyTitlePane.this.setActive(false);
        }
    }

    private class PropertyChangeHandler
    implements PropertyChangeListener {
        private PropertyChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if ("resizable".equals(string) || "state".equals(string)) {
                Frame frame = TinyTitlePane.this.getFrame();
                if (frame != null) {
                    TinyTitlePane.this.setState(frame.getExtendedState(), true);
                }
                if ("resizable".equals(string)) {
                    TinyTitlePane.this.getRootPane().repaint();
                }
            } else if ("title".equals(string)) {
                TinyTitlePane.this.repaint();
            } else if ("componentOrientation".equals(string)) {
                TinyTitlePane.this.revalidate();
                TinyTitlePane.this.repaint();
            } else if ("iconImage".equals(string)) {
                TinyTitlePane.this.updateSystemIcon();
                TinyTitlePane.this.revalidate();
                TinyTitlePane.this.repaint();
            }
        }
    }

    private class TitlePaneLayout
    implements LayoutManager {
        private TitlePaneLayout() {
        }

        public void addLayoutComponent(String string, Component component) {
        }

        public void removeLayoutComponent(Component component) {
        }

        public Dimension preferredLayoutSize(Container container) {
            return new Dimension(104, this.computeHeight());
        }

        public Dimension minimumLayoutSize(Container container) {
            return this.preferredLayoutSize(container);
        }

        private int computeHeight() {
            Window window = TinyTitlePane.this.getWindow();
            if (window instanceof Frame) {
                TinyTitlePane.this.setMaximizeBounds(TinyTitlePane.this.getFrame());
                return 29;
            }
            if (window instanceof Dialog) {
                return 29;
            }
            return 25;
        }

        public void layoutContainer(Container container) {
            int n;
            int n2;
            int n3;
            if (TinyTitlePane.this.getWindowDecorationStyle() == 0) {
                TinyTitlePane.this.buttonsWidth = 0;
                return;
            }
            boolean bl = TinyTitlePane.this.window == null ? TinyTitlePane.this.getRootPane().getComponentOrientation().isLeftToRight() : TinyTitlePane.this.window.getComponentOrientation().isLeftToRight();
            int n4 = TinyTitlePane.this.getWidth();
            if (TinyTitlePane.this.closeButton != null) {
                n3 = ((TinyTitlePane)TinyTitlePane.this).closeButton.getPreferredSize().height;
                n2 = ((TinyTitlePane)TinyTitlePane.this).closeButton.getPreferredSize().width;
            } else {
                n3 = 16;
                n2 = 16;
            }
            int n5 = TinyTitlePane.this.getHeight() == 29 ? 1 : 0;
            int n6 = (TinyTitlePane.this.getHeight() - n3) / 2 + n5;
            int n7 = 5;
            int n8 = n = bl ? n7 : n4 - n2 - n7;
            if (TinyTitlePane.this.menuBar != null) {
                TinyTitlePane.this.menuBar.setBounds(n, n6, n2, n3);
            }
            n = bl ? n4 : 0;
            n7 = 2;
            n += bl ? -n7 - n2 : n7;
            if (TinyTitlePane.this.closeButton != null) {
                TinyTitlePane.this.closeButton.setBounds(n, n6, n2, n3);
            }
            if (!bl) {
                n += n2;
            }
            if (Toolkit.getDefaultToolkit().isFrameStateSupported(6) && TinyTitlePane.this.toggleButton.getParent() != null) {
                TinyTitlePane.this.toggleButton.setBounds(n += bl ? -n7 - n2 : n7, n6, n2, n3);
                if (!bl) {
                    n += n2;
                }
            }
            if (TinyTitlePane.this.iconifyButton != null && TinyTitlePane.this.iconifyButton.getParent() != null) {
                TinyTitlePane.this.iconifyButton.setBounds(n += bl ? -n7 - n2 : n7, n6, n2, n3);
                if (!bl) {
                    n += n2;
                }
            }
            TinyTitlePane.this.buttonsWidth = bl ? n4 - n : n;
        }
    }

    private class SystemMenuBar
    extends JMenuBar {
        private SystemMenuBar() {
        }

        public void paint(Graphics graphics) {
            int n = this.getHeight();
            if (TinyTitlePane.this.systemIcon != null) {
                graphics.drawImage(TinyTitlePane.this.systemIcon, 0, (n - 16) / 2 + 1, 16, 16, null);
            } else {
                Icon icon = UIManager.getIcon("InternalFrame.icon");
                if (icon != null) {
                    icon.paintIcon(this, graphics, 0, (n - icon.getIconHeight()) / 2 + 1);
                }
            }
        }

        private Window getOwningFrame(Dialog dialog) {
            Window window;
            while ((window = dialog.getOwner()) != null) {
                if (!(window instanceof Dialog)) {
                    return window;
                }
                dialog = (Dialog)window;
            }
            return window;
        }

        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        public Dimension getPreferredSize() {
            if (TinyTitlePane.this.systemIcon != null) {
                return new Dimension(16, 16);
            }
            Icon icon = UIManager.getIcon("InternalFrame.icon");
            if (icon != null) {
                return new Dimension(icon.getIconWidth(), icon.getIconHeight());
            }
            Dimension dimension = super.getPreferredSize();
            return new Dimension(Math.max(16, dimension.width), Math.max(dimension.height, 16));
        }
    }

    private class MaximizeAction
    extends AbstractAction {
        public MaximizeAction() {
            super(UIManager.getString((Object)"MetalTitlePane.maximizeTitle", TinyTitlePane.this.getLocale()));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            TinyTitlePane.this.maximize();
        }
    }

    private class RestoreAction
    extends AbstractAction {
        public RestoreAction() {
            super(UIManager.getString((Object)"MetalTitlePane.restoreTitle", TinyTitlePane.this.getLocale()));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            TinyTitlePane.this.restore();
        }
    }

    private class IconifyAction
    extends AbstractAction {
        public IconifyAction() {
            super(UIManager.getString((Object)"MetalTitlePane.iconifyTitle", TinyTitlePane.this.getLocale()));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            TinyTitlePane.this.iconify();
        }
    }

    private class CloseAction
    extends AbstractAction {
        public CloseAction() {
            super(UIManager.getString((Object)"MetalTitlePane.closeTitle", TinyTitlePane.this.getLocale()));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            TinyTitlePane.this.close();
        }
    }
}

