/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects.graphics;

import java.awt.Color;
import java.awt.Paint;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Logger;
import org.icepdf.core.pobjects.functions.Function;
import org.icepdf.core.pobjects.graphics.DeviceN;
import org.icepdf.core.pobjects.graphics.PColorSpace;
import org.icepdf.core.pobjects.graphics.ShadingPattern;
import org.icepdf.core.pobjects.graphics.batik.ext.awt.MultipleGradientPaint;
import org.icepdf.core.pobjects.graphics.batik.ext.awt.RadialGradientPaint;
import org.icepdf.core.util.Library;

public class ShadingType3Pattern
extends ShadingPattern {
    private static final Logger logger = Logger.getLogger(ShadingType3Pattern.class.toString());
    protected Function[] function;
    protected List<Number> domain;
    protected List coords;
    protected List<Boolean> extend;
    protected RadialGradientPaint radialGradientPaint;

    public ShadingType3Pattern(Library library, HashMap entries) {
        super(library, entries);
    }

    public synchronized void init() {
        if (this.inited) {
            return;
        }
        if (this.shading == null) {
            this.shading = this.library.getDictionary(this.entries, SHADING_KEY);
        }
        this.shadingType = this.library.getInt(this.shading, SHADING_TYPE_KEY);
        this.bBox = this.library.getRectangle(this.shading, BBOX_KEY);
        this.colorSpace = PColorSpace.getColorSpace(this.library, this.library.getObject(this.shading, COLORSPACE_KEY));
        if (this.library.getObject(this.shading, BACKGROUND_KEY) != null && this.library.getObject(this.shading, BACKGROUND_KEY) instanceof List) {
            this.background = (List)this.library.getObject(this.shading, BACKGROUND_KEY);
        }
        this.antiAlias = this.library.getBoolean(this.shading, ANTIALIAS_KEY);
        Object tmp = this.library.getObject(this.shading, DOMAIN_KEY);
        if (tmp instanceof List) {
            this.domain = (List)tmp;
        } else {
            this.domain = new ArrayList<Number>(2);
            this.domain.add(new Float(0.0));
            this.domain.add(new Float(1.0));
        }
        tmp = this.library.getObject(this.shading, COORDS_KEY);
        if (tmp instanceof List) {
            this.coords = (List)tmp;
        }
        if ((tmp = this.library.getObject(this.shading, EXTEND_KEY)) instanceof List) {
            this.extend = (List)tmp;
        } else {
            this.extend = new ArrayList<Boolean>(2);
            this.extend.add(false);
            this.extend.add(false);
        }
        tmp = this.library.getObject(this.shading, FUNCTION_KEY);
        if (tmp != null) {
            if (!(tmp instanceof List)) {
                this.function = new Function[]{Function.getFunction(this.library, tmp)};
            } else {
                List functionTemp = (List)tmp;
                this.function = new Function[functionTemp.size()];
                for (int i = 0; i < functionTemp.size(); ++i) {
                    this.function[i] = Function.getFunction(this.library, functionTemp.get(i));
                }
            }
        }
        float t0 = this.domain.get(0).floatValue();
        float t1 = this.domain.get(1).floatValue();
        float[] s = new float[]{0.0f, 0.25f, 0.5f, 0.75f, 1.0f};
        Point2D.Float center = new Point2D.Float(((Number)this.coords.get(0)).floatValue(), ((Number)this.coords.get(1)).floatValue());
        Point2D.Float focus = new Point2D.Float(((Number)this.coords.get(3)).floatValue(), ((Number)this.coords.get(4)).floatValue());
        float radius = ((Number)this.coords.get(2)).floatValue();
        float radius2 = ((Number)this.coords.get(5)).floatValue();
        if (radius2 > radius) {
            radius = radius2;
        }
        Color color1 = this.calculateColour(this.colorSpace, s[0], t0, t1);
        Color color2 = this.calculateColour(this.colorSpace, s[1], t0, t1);
        Color color3 = this.calculateColour(this.colorSpace, s[2], t0, t1);
        Color color4 = this.calculateColour(this.colorSpace, s[3], t0, t1);
        Color color5 = this.calculateColour(this.colorSpace, s[4], t0, t1);
        if (color1 == null || color2 == null) {
            return;
        }
        Color[] colors = new Color[]{color1, color2, color3, color4, color5};
        this.radialGradientPaint = new RadialGradientPaint(center, radius, focus, s, colors, MultipleGradientPaint.NO_CYCLE, MultipleGradientPaint.LINEAR_RGB, this.matrix);
        this.inited = true;
    }

    private Color calculateColour(PColorSpace colorSpace, float s, float t0, float t1) {
        float t = this.parametrixValue(s, t0, t1, this.extend);
        float[] input = new float[]{t};
        if (this.function != null) {
            float[] output;
            int length = this.function.length;
            if (length == 1) {
                output = this.function[0].calculate(input);
            } else {
                output = new float[length];
                for (int i = 0; i < length; ++i) {
                    output[i] = this.function[i].calculate(input)[0];
                }
            }
            if (output != null) {
                if (!(colorSpace instanceof DeviceN)) {
                    output = PColorSpace.reverse(output);
                }
                return colorSpace.getColor(output);
            }
            return null;
        }
        logger.fine("Error processing Shading Type 3 Pattern.");
        return null;
    }

    private float parametrixValue(float linearMapping, float t0, float t1, List extended) {
        return t0 + (t1 - t0) * linearMapping;
    }

    public Paint getPaint() {
        this.init();
        return this.radialGradientPaint;
    }

    public String toSting() {
        return super.toString() + "\n                    domain: " + this.domain + "\n                    coords: " + this.coords + "\n                    extend: " + this.extend + "\n                 function: " + this.function;
    }
}

