/*
 * Decompiled with CFR 0.152.
 */
package de.muntjak.tinylookandfeel.util;

import de.muntjak.tinylookandfeel.Theme;
import de.muntjak.tinylookandfeel.controlpanel.ControlPanel;
import de.muntjak.tinylookandfeel.controlpanel.SBControl;
import de.muntjak.tinylookandfeel.util.ColorRoutines;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.plaf.ColorUIResource;

public class SBReference {
    public static final int ABS_COLOR = 1;
    public static final int MAIN_COLOR = 2;
    public static final int BACK_COLOR = 3;
    public static final int DIS_COLOR = 4;
    public static final int FRAME_COLOR = 5;
    public static final int SUB1_COLOR = 6;
    public static final int SUB2_COLOR = 7;
    public static final int SUB3_COLOR = 8;
    public static final int SUB4_COLOR = 9;
    public static final int SUB5_COLOR = 10;
    public static final int SUB6_COLOR = 11;
    public static final int SUB7_COLOR = 12;
    public static final int SUB8_COLOR = 13;
    private static final Vector instances = new Vector();
    protected ColorUIResource color;
    protected ColorUIResource referenceColor;
    protected int sat = 0;
    protected int bri = 0;
    protected int ref;
    protected boolean locked;
    protected ColorIcon icon;
    protected static ColorIcon absoluteIcon;

    public SBReference() {
        this.color = new ColorUIResource(Color.BLACK);
        this.ref = 1;
        instances.add(this);
    }

    public SBReference(boolean bl) {
        this.color = new ColorUIResource(Color.BLACK);
        this.ref = 1;
    }

    public SBReference(Color color, int n, int n2, int n3) {
        this.color = new ColorUIResource(color);
        this.sat = n;
        this.bri = n2;
        this.ref = n3;
        instances.add(this);
    }

    public SBReference(Color color, int n, int n2, int n3, boolean bl) {
        this.color = new ColorUIResource(color);
        this.sat = n;
        this.bri = n2;
        this.ref = n3;
        this.locked = bl;
    }

    public SBReference(SBReference sBReference) {
        this.color = new ColorUIResource(sBReference.color);
        this.sat = sBReference.sat;
        this.bri = sBReference.bri;
        this.ref = sBReference.ref;
        this.locked = sBReference.locked;
    }

    public SBReference copy() {
        SBReference sBReference = new SBReference(this);
        if (!this.isAbsoluteColor()) {
            sBReference.referenceColor = this.getReferenceColor();
        }
        return sBReference;
    }

    public static int getNumReferences(int n) {
        int n2 = 0;
        Iterator iterator = instances.iterator();
        while (iterator.hasNext()) {
            if (n != ((SBReference)iterator.next()).ref) continue;
            ++n2;
        }
        return n2;
    }

    public static void printReferences(int n) {
        Iterator iterator = instances.iterator();
        while (iterator.hasNext()) {
            SBReference sBReference = (SBReference)iterator.next();
            if (n != sBReference.ref) continue;
            System.out.println(sBReference);
        }
    }

    public void update(Color color, int n, int n2, int n3) {
        this.color = new ColorUIResource(color);
        this.sat = n;
        this.bri = n2;
        this.ref = n3;
    }

    public void update(SBReference sBReference) {
        if (sBReference.isAbsoluteColor() || sBReference.referenceColor == null) {
            this.color = new ColorUIResource(sBReference.color);
            this.sat = sBReference.sat;
            this.bri = sBReference.bri;
            this.ref = sBReference.ref;
        } else {
            this.update(sBReference, sBReference.referenceColor);
        }
    }

    public void update(SBReference sBReference, Vector vector) {
        if (sBReference.isAbsoluteColor()) {
            this.color = new ColorUIResource(sBReference.color);
            this.sat = sBReference.sat;
            this.bri = sBReference.bri;
            this.ref = sBReference.ref;
        } else {
            this.update(sBReference, (ColorUIResource)vector.get(sBReference.ref - 2));
        }
    }

    private void update(SBReference sBReference, ColorUIResource colorUIResource) {
        if (!sBReference.getReferenceColor().equals(colorUIResource)) {
            int n = this.getRefForColor(colorUIResource);
            if (n != -1) {
                this.ref = n;
                this.sat = sBReference.sat;
                this.bri = sBReference.bri;
                return;
            }
            n = this.getEmptyReferenceColor();
            if (n != -1) {
                this.ref = n;
                SBControl sBControl = ControlPanel.instance.getSBControlFromRef(this.ref);
                sBControl.getSBReference().setReference(1);
                sBControl.getSBReference().setSaturation(0);
                sBControl.getSBReference().setBrightness(0);
                sBControl.getSBReference().setColor(colorUIResource);
                sBControl.update();
                this.sat = sBReference.sat;
                this.bri = sBReference.bri;
                return;
            }
            this.color = new ColorUIResource(sBReference.getColor());
            this.sat = 0;
            this.bri = 0;
            this.ref = 1;
            return;
        }
        this.color = new ColorUIResource(sBReference.color);
        this.sat = sBReference.sat;
        this.bri = sBReference.bri;
        this.ref = sBReference.ref;
    }

    private int getEmptyReferenceColor() {
        for (int i = 6; i <= 13; ++i) {
            if (SBReference.getNumReferences(i) != 0) continue;
            return i;
        }
        return -1;
    }

    private int getRefForColor(ColorUIResource colorUIResource) {
        if (Theme.mainColor.getColor().equals(colorUIResource)) {
            return 2;
        }
        if (Theme.backColor.getColor().equals(colorUIResource)) {
            return 3;
        }
        if (Theme.disColor.getColor().equals(colorUIResource)) {
            return 4;
        }
        if (Theme.frameColor.getColor().equals(colorUIResource)) {
            return 5;
        }
        if (Theme.sub1Color.getColor().equals(colorUIResource)) {
            return 6;
        }
        if (Theme.sub2Color.getColor().equals(colorUIResource)) {
            return 7;
        }
        if (Theme.sub3Color.getColor().equals(colorUIResource)) {
            return 8;
        }
        if (Theme.sub4Color.getColor().equals(colorUIResource)) {
            return 9;
        }
        if (Theme.sub5Color.getColor().equals(colorUIResource)) {
            return 10;
        }
        if (Theme.sub6Color.getColor().equals(colorUIResource)) {
            return 11;
        }
        if (Theme.sub7Color.getColor().equals(colorUIResource)) {
            return 12;
        }
        if (Theme.sub8Color.getColor().equals(colorUIResource)) {
            return 13;
        }
        return -1;
    }

    public void update(Color color) {
        this.color = new ColorUIResource(color);
        this.sat = 0;
        this.bri = 0;
        this.ref = 1;
    }

    public void reset() {
        this.sat = 0;
        this.bri = 0;
    }

    public ColorUIResource getColor() {
        return this.color;
    }

    public int getSaturation() {
        return this.sat;
    }

    public int getBrightness() {
        return this.bri;
    }

    public int getReference() {
        return this.ref;
    }

    public ColorUIResource getReferenceColor() {
        return SBReference.getReferencedColor(this.ref);
    }

    public static ColorUIResource getReferencedColor(int n) {
        switch (n) {
            case 2: {
                return Theme.mainColor.getColor();
            }
            case 3: {
                return Theme.backColor.getColor();
            }
            case 4: {
                return Theme.disColor.getColor();
            }
            case 5: {
                return Theme.frameColor.getColor();
            }
            case 6: {
                return Theme.sub1Color.getColor();
            }
            case 7: {
                return Theme.sub2Color.getColor();
            }
            case 8: {
                return Theme.sub3Color.getColor();
            }
            case 9: {
                return Theme.sub4Color.getColor();
            }
            case 10: {
                return Theme.sub5Color.getColor();
            }
            case 11: {
                return Theme.sub6Color.getColor();
            }
            case 12: {
                return Theme.sub7Color.getColor();
            }
            case 13: {
                return Theme.sub8Color.getColor();
            }
        }
        return null;
    }

    public String getReferenceString() {
        switch (this.ref) {
            case 2: {
                return "Main Color";
            }
            case 3: {
                return "Back Color";
            }
            case 4: {
                return "Disabled Color";
            }
            case 5: {
                return "Frame Color";
            }
            case 6: {
                return "Sub1 Color";
            }
            case 7: {
                return "Sub2 Color";
            }
            case 8: {
                return "Sub3 Color";
            }
            case 9: {
                return "Sub4 Color";
            }
            case 10: {
                return "Sub5 Color";
            }
            case 11: {
                return "Sub6 Color";
            }
            case 12: {
                return "Sub7 Color";
            }
            case 13: {
                return "Sub8 Color";
            }
        }
        return "";
    }

    public void setColor(Color color) {
        this.color = new ColorUIResource(color);
    }

    public void setSaturation(int n) {
        this.sat = n;
    }

    public void setBrightness(int n) {
        this.bri = n;
    }

    public void setReference(int n) {
        this.ref = n;
    }

    public void setColor(int n, int n2) {
        if (this.isAbsoluteColor()) {
            return;
        }
        this.sat = n;
        this.bri = n2;
        this.updateColor();
    }

    private void updateColor() {
        switch (this.ref) {
            case 2: {
                this.color = new ColorUIResource(ColorRoutines.getAdjustedColor(Theme.mainColor.getColor(), this.sat, this.bri));
                break;
            }
            case 3: {
                this.color = new ColorUIResource(ColorRoutines.getAdjustedColor(Theme.backColor.getColor(), this.sat, this.bri));
                break;
            }
            case 4: {
                this.color = new ColorUIResource(ColorRoutines.getAdjustedColor(Theme.disColor.getColor(), this.sat, this.bri));
                break;
            }
            case 5: {
                this.color = new ColorUIResource(ColorRoutines.getAdjustedColor(Theme.frameColor.getColor(), this.sat, this.bri));
                break;
            }
            case 6: {
                this.color = new ColorUIResource(ColorRoutines.getAdjustedColor(Theme.sub1Color.getColor(), this.sat, this.bri));
                break;
            }
            case 7: {
                this.color = new ColorUIResource(ColorRoutines.getAdjustedColor(Theme.sub2Color.getColor(), this.sat, this.bri));
                break;
            }
            case 8: {
                this.color = new ColorUIResource(ColorRoutines.getAdjustedColor(Theme.sub3Color.getColor(), this.sat, this.bri));
                break;
            }
            case 9: {
                this.color = new ColorUIResource(ColorRoutines.getAdjustedColor(Theme.sub4Color.getColor(), this.sat, this.bri));
                break;
            }
            case 10: {
                this.color = new ColorUIResource(ColorRoutines.getAdjustedColor(Theme.sub5Color.getColor(), this.sat, this.bri));
                break;
            }
            case 11: {
                this.color = new ColorUIResource(ColorRoutines.getAdjustedColor(Theme.sub6Color.getColor(), this.sat, this.bri));
                break;
            }
            case 12: {
                this.color = new ColorUIResource(ColorRoutines.getAdjustedColor(Theme.sub7Color.getColor(), this.sat, this.bri));
                break;
            }
            case 13: {
                this.color = new ColorUIResource(ColorRoutines.getAdjustedColor(Theme.sub8Color.getColor(), this.sat, this.bri));
            }
        }
    }

    public ColorUIResource update() {
        if (this.isAbsoluteColor()) {
            return this.color;
        }
        this.updateColor();
        return this.color;
    }

    public boolean isAbsoluteColor() {
        return this.ref == 1;
    }

    public boolean isReferenceColor() {
        return this.locked || this.equals(Theme.sub1Color) || this.equals(Theme.sub2Color) || this.equals(Theme.sub3Color) || this.equals(Theme.sub4Color) || this.equals(Theme.sub5Color) || this.equals(Theme.sub6Color) || this.equals(Theme.sub7Color) || this.equals(Theme.sub8Color);
    }

    public void setLocked(boolean bl) {
        this.locked = bl;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public String toString() {
        return "SBReference[bri=" + this.bri + ",sat=" + this.sat + ",ref=" + this.ref + ",c=(" + this.color.getRed() + "," + this.color.getGreen() + "," + this.color.getBlue() + ")]";
    }

    public Icon getIcon() {
        if (this.icon == null) {
            this.icon = new ColorIcon(false);
        }
        return this.icon;
    }

    public Icon getAbsoluteIcon() {
        if (absoluteIcon == null) {
            absoluteIcon = new ColorIcon(true);
        }
        return absoluteIcon;
    }

    public void save(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(this.color.getRGB());
        dataOutputStream.writeInt(this.sat);
        dataOutputStream.writeInt(this.bri);
        dataOutputStream.writeInt(this.ref);
        dataOutputStream.writeBoolean(this.locked);
    }

    public void load(DataInputStream dataInputStream) throws IOException {
        try {
            this.color = Theme.fileID >= 12852 ? new ColorUIResource(dataInputStream.readInt()) : new ColorUIResource(dataInputStream.readInt(), dataInputStream.readInt(), dataInputStream.readInt());
            this.sat = dataInputStream.readInt();
            this.bri = dataInputStream.readInt();
            this.ref = dataInputStream.readInt();
            this.locked = dataInputStream.readBoolean();
        }
        catch (Exception exception) {
            throw new IOException("SBReference.load() : " + exception);
        }
    }

    public static void loadDummyData(DataInputStream dataInputStream) throws IOException {
        try {
            if (Theme.fileID >= 12852) {
                dataInputStream.readInt();
            } else {
                dataInputStream.readInt();
                dataInputStream.readInt();
                dataInputStream.readInt();
            }
            dataInputStream.readInt();
            dataInputStream.readInt();
            dataInputStream.readInt();
            dataInputStream.readBoolean();
        }
        catch (Exception exception) {
            throw new IOException("SBReference.loadDummyData() : " + exception.getMessage());
        }
    }

    class ColorIcon
    implements Icon {
        private boolean paintGradients;

        ColorIcon(boolean bl) {
            this.paintGradients = bl;
        }

        public int getIconHeight() {
            return 16;
        }

        public int getIconWidth() {
            return 16;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            Color color = graphics.getColor();
            graphics.setColor(Color.GRAY);
            graphics.drawRect(n, n2, this.getIconWidth(), this.getIconHeight());
            if (this.paintGradients) {
                float f = 0.0f;
                for (int i = 0; i < 15; ++i) {
                    graphics.setColor(Color.getHSBColor(f, 0.5f, 1.0f));
                    graphics.drawLine(n + 1 + i, n2 + 1, n + 1 + i, n2 + this.getIconHeight() - 1);
                    f = (float)((double)f + 0.0625);
                }
            } else {
                graphics.setColor(SBReference.this.color);
                graphics.fillRect(n + 1, n2 + 1, this.getIconWidth() - 1, this.getIconHeight() - 1);
            }
            if (component instanceof AbstractButton && ((AbstractButton)component).isSelected()) {
                graphics.setColor(Color.WHITE);
                this.drawArrow(graphics, n + 1, n2 + 1);
                graphics.setColor(Color.BLACK);
                this.drawArrow(graphics, n, n2);
            }
            graphics.setColor(color);
        }

        private void drawArrow(Graphics graphics, int n, int n2) {
            graphics.drawLine(n + 3, n2 + 5, n + 3, n2 + 7);
            graphics.drawLine(n + 4, n2 + 6, n + 4, n2 + 8);
            graphics.drawLine(n + 5, n2 + 7, n + 5, n2 + 9);
            graphics.drawLine(n + 6, n2 + 6, n + 6, n2 + 8);
            graphics.drawLine(n + 7, n2 + 5, n + 7, n2 + 7);
            graphics.drawLine(n + 8, n2 + 4, n + 8, n2 + 6);
            graphics.drawLine(n + 9, n2 + 3, n + 9, n2 + 5);
        }
    }
}

