/*
 * Decompiled with CFR 0.152.
 */
package de.muntjak.tinylookandfeel.borders;

import de.muntjak.tinylookandfeel.Theme;
import de.muntjak.tinylookandfeel.TinyLookAndFeel;
import de.muntjak.tinylookandfeel.TinyPopupFactory;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.border.AbstractBorder;
import javax.swing.plaf.UIResource;

public class TinyPopupMenuBorder
extends AbstractBorder
implements UIResource {
    public static final int SHADOW_SIZE = 5;
    private static final Insets INSETS_NO_SHADOW = new Insets(2, 2, 2, 2);
    private static final Insets INSETS_SHADOW_LEFT_TO_RIGHT = new Insets(2, 2, 7, 7);
    private static final Insets INSETS_SHADOW_RIGHT_TO_LEFT = new Insets(2, 7, 7, 2);
    public static final Image LEFT_TO_RIGHT_SHADOW_MASK = TinyLookAndFeel.loadIcon("leftToRightShadow.png").getImage();
    public static final Image RIGHT_TO_LEFT_SHADOW_MASK = TinyLookAndFeel.loadIcon("rightToLeftShadow.png").getImage();

    public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        boolean bl = Boolean.TRUE.equals(((JComponent)component).getClientProperty("SHADOW_POPUP_KEY"));
        boolean bl2 = this.isOrientationLeftToRight(component);
        graphics.translate(n, n2);
        int n5 = 0;
        int n6 = n3;
        int n7 = n4;
        if (bl) {
            if (bl2) {
                BufferedImage bufferedImage = (BufferedImage)((JComponent)component).getClientProperty("VERTICAL_IMAGE_KEY");
                graphics.drawImage(bufferedImage, n6 -= 5, 0, component);
                bufferedImage = (BufferedImage)((JComponent)component).getClientProperty("HORIZONTAL_IMAGE_KEY");
                graphics.drawImage(bufferedImage, 0, n7 -= 5, component);
            } else {
                n7 -= 5;
                n5 = 5;
                BufferedImage bufferedImage = (BufferedImage)((JComponent)component).getClientProperty("VERTICAL_IMAGE_KEY");
                if (bufferedImage != null) {
                    graphics.drawImage(bufferedImage, 0, 0, component);
                }
                if ((bufferedImage = (BufferedImage)((JComponent)component).getClientProperty("HORIZONTAL_IMAGE_KEY")) != null) {
                    graphics.drawImage(bufferedImage, 0, n7, component);
                }
            }
        }
        graphics.setColor(Theme.menuInnerHilightColor.getColor());
        graphics.drawLine(n5 + 1, 1, n6 - 3, 1);
        if (bl2) {
            graphics.drawLine(n5 + 1, 1, n5 + 1, n7 - 3);
        } else {
            graphics.drawLine(n6 - 2, 1, n6 - 2, n7 - 2);
        }
        graphics.setColor(Theme.menuInnerShadowColor.getColor());
        if (bl2) {
            graphics.drawLine(n6 - 2, 1, n6 - 2, n7 - 2);
        } else {
            graphics.drawLine(n5 + 1, 1, n5 + 1, n7 - 2);
        }
        graphics.drawLine(n5 + 1, n7 - 2, n6 - 2, n7 - 2);
        graphics.setColor(Theme.menuOuterHilightColor.getColor());
        graphics.drawLine(n5, 0, n6 - 2, 0);
        graphics.drawLine(n5, 0, n5, n7 - 1);
        graphics.setColor(Theme.menuOuterShadowColor.getColor());
        graphics.drawLine(n6 - 1, 0, n6 - 1, n7 - 1);
        graphics.drawLine(n5, n7 - 1, n6 - 1, n7 - 1);
        if (bl) {
            if (bl2) {
                graphics.drawImage(LEFT_TO_RIGHT_SHADOW_MASK, n6, 4, n6 + 5, 8, 6, 0, 11, 4, component);
                graphics.drawImage(LEFT_TO_RIGHT_SHADOW_MASK, 4, n7, 8, n7 + 5, 0, 6, 4, 11, component);
                graphics.drawImage(LEFT_TO_RIGHT_SHADOW_MASK, n6, n7, n6 + 5, n7 + 5, 6, 6, 11, 11, component);
                graphics.drawImage(LEFT_TO_RIGHT_SHADOW_MASK, n6, 8, n6 + 5, n7, 6, 4, 11, 5, component);
                graphics.drawImage(LEFT_TO_RIGHT_SHADOW_MASK, 8, n7, n6, n7 + 5, 4, 6, 5, 11, component);
            } else {
                graphics.drawImage(RIGHT_TO_LEFT_SHADOW_MASK, 0, 4, 5, 8, 0, 0, 5, 4, component);
                graphics.drawImage(RIGHT_TO_LEFT_SHADOW_MASK, n6 - 8, n7, n6 - 4, n7 + 5, 7, 6, 11, 11, component);
                graphics.drawImage(RIGHT_TO_LEFT_SHADOW_MASK, 0, n7, 5, n7 + 5, 0, 6, 6, 11, component);
                graphics.drawImage(RIGHT_TO_LEFT_SHADOW_MASK, 0, 8, 5, n7, 0, 4, 5, 5, component);
                graphics.drawImage(RIGHT_TO_LEFT_SHADOW_MASK, 5, n7, n6 - 8, n7 + 5, 5, 6, 6, 11, component);
            }
        }
        graphics.translate(-n, -n2);
    }

    public Insets getBorderInsets(Component component) {
        if (TinyPopupFactory.isPopupShadowEnabled()) {
            if (this.isOrientationLeftToRight(component)) {
                return INSETS_SHADOW_LEFT_TO_RIGHT;
            }
            return INSETS_SHADOW_RIGHT_TO_LEFT;
        }
        return INSETS_NO_SHADOW;
    }

    private boolean isOrientationLeftToRight(Component component) {
        Component component2;
        if (!(component instanceof JComponent)) {
            return true;
        }
        Object object = ((JComponent)component).getClientProperty("COMPONENT_ORIENTATION_KEY");
        if (object == null && component instanceof JPopupMenu && (component2 = ((JPopupMenu)component).getInvoker()) != null) {
            object = component2.getComponentOrientation();
        }
        return object == null ? true : ((ComponentOrientation)object).isLeftToRight();
    }

    public static String componentOrientationToString(ComponentOrientation componentOrientation) {
        if (componentOrientation == null) {
            return "<null>";
        }
        return componentOrientation.isLeftToRight() ? "left-to-right" : "right-to-left";
    }
}

