/*
 * Decompiled with CFR 0.152.
 */
package de.muntjak.tinylookandfeel;

import de.muntjak.tinylookandfeel.Theme;
import de.muntjak.tinylookandfeel.TinyComboBoxButton;
import de.muntjak.tinylookandfeel.TinyComboBoxEditor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.InsetsUIResource;
import javax.swing.plaf.basic.BasicComboBoxUI;

public class TinyComboBoxUI
extends BasicComboBoxUI {
    static final int COMBO_BUTTON_WIDTH = 18;
    protected boolean isDisplaySizeDirty = true;
    protected Dimension cachedDisplaySize = new Dimension(0, 0);
    private static final Insets DEFAULT_INSETS = new Insets(0, 0, 0, 0);

    public static ComponentUI createUI(JComponent jComponent) {
        return new TinyComboBoxUI();
    }

    public void paint(Graphics graphics, JComponent jComponent) {
    }

    protected ComboBoxEditor createEditor() {
        return new TinyComboBoxEditor.UIResource();
    }

    protected JButton createArrowButton() {
        TinyComboBoxButton tinyComboBoxButton = new TinyComboBoxButton(this.comboBox, null, this.comboBox.isEditable(), this.currentValuePane, this.listBox);
        tinyComboBoxButton.setMargin(DEFAULT_INSETS);
        tinyComboBoxButton.putClientProperty("isComboBoxButton", Boolean.TRUE);
        return tinyComboBoxButton;
    }

    protected void installComponents() {
        super.installComponents();
        if (this.arrowButton != null) {
            this.arrowButton.setFocusable(false);
        }
    }

    public PropertyChangeListener createPropertyChangeListener() {
        return new TinyPropertyChangeListener();
    }

    protected void editablePropertyChanged(PropertyChangeEvent propertyChangeEvent) {
    }

    protected LayoutManager createLayoutManager() {
        return new TinyComboBoxLayoutManager();
    }

    protected Rectangle rectangleForCurrentValue2() {
        int n = this.comboBox.getWidth();
        int n2 = this.comboBox.getHeight();
        Insets insets = this.getInsets();
        int n3 = n2 - (insets.top + insets.bottom);
        if (this.arrowButton != null) {
            n3 = 18;
        }
        if (this.comboBox.getComponentOrientation().isLeftToRight()) {
            return new Rectangle(insets.left, insets.top, n - (insets.left + insets.right + n3), n2 - (insets.top + insets.bottom));
        }
        return new Rectangle(insets.left + n3, insets.top, n - (insets.left + insets.right + n3), n2 - (insets.top + insets.bottom));
    }

    protected void removeListeners() {
        if (this.propertyChangeListener != null) {
            this.comboBox.removePropertyChangeListener(this.propertyChangeListener);
        }
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        if (!this.isMinimumSizeDirty) {
            this.isDisplaySizeDirty = true;
            return new Dimension(this.cachedMinimumSize);
        }
        InsetsUIResource insetsUIResource = Theme.comboInsets;
        Dimension dimension = this.getDisplaySize();
        dimension.width += 18;
        dimension.width += insetsUIResource.left + insetsUIResource.right;
        dimension.height += insetsUIResource.top + insetsUIResource.bottom;
        this.cachedMinimumSize.setSize(dimension.width, dimension.height);
        this.isMinimumSizeDirty = false;
        return new Dimension(this.cachedMinimumSize);
    }

    protected Dimension getDisplaySize() {
        ComboBoxModel comboBoxModel;
        Object e;
        if (!this.isDisplaySizeDirty) {
            return new Dimension(this.cachedDisplaySize);
        }
        Dimension dimension = new Dimension();
        DefaultListCellRenderer defaultListCellRenderer = this.comboBox.getRenderer();
        if (defaultListCellRenderer == null) {
            defaultListCellRenderer = new DefaultListCellRenderer();
        }
        if ((e = this.comboBox.getPrototypeDisplayValue()) != null) {
            dimension = this.getSizeForComponent(defaultListCellRenderer.getListCellRendererComponent(this.listBox, e, -1, false, false));
        } else {
            comboBoxModel = this.comboBox.getModel();
            int n = comboBoxModel.getSize();
            if (n > 0) {
                for (int i = 0; i < n; ++i) {
                    Dimension dimension2 = this.getSizeForComponent(defaultListCellRenderer.getListCellRendererComponent(this.listBox, comboBoxModel.getElementAt(i), -1, false, false));
                    dimension.width = Math.max(dimension.width, dimension2.width);
                    dimension.height = Math.max(dimension.height, dimension2.height);
                }
            } else {
                dimension = this.getDefaultSize();
                if (this.comboBox.isEditable()) {
                    dimension.width = 100;
                }
            }
        }
        if (this.comboBox.isEditable()) {
            comboBoxModel = this.editor.getPreferredSize();
            dimension.width = Math.max(dimension.width, ((Dimension)((Object)comboBoxModel)).width);
            dimension.height = Math.max(dimension.height, ((Dimension)((Object)comboBoxModel)).height);
        }
        this.cachedDisplaySize.setSize(dimension.width, dimension.height);
        this.isDisplaySizeDirty = false;
        return dimension;
    }

    private Dimension getSizeForComponent(Component component) {
        this.currentValuePane.add(component);
        component.setFont(this.comboBox.getFont());
        Dimension dimension = component.getPreferredSize();
        this.currentValuePane.remove(component);
        return dimension;
    }

    public class TinyComboBoxLayoutManager
    implements LayoutManager {
        public void addLayoutComponent(String string, Component component) {
        }

        public void removeLayoutComponent(Component component) {
        }

        public Dimension preferredLayoutSize(Container container) {
            JComboBox jComboBox = (JComboBox)container;
            return container.getPreferredSize();
        }

        public Dimension minimumLayoutSize(Container container) {
            JComboBox jComboBox = (JComboBox)container;
            return container.getMinimumSize();
        }

        public void layoutContainer(Container container) {
            JComboBox jComboBox = (JComboBox)container;
            int n = jComboBox.getWidth();
            int n2 = jComboBox.getHeight();
            if (TinyComboBoxUI.this.comboBox.isEditable()) {
                if (TinyComboBoxUI.this.arrowButton != null) {
                    TinyComboBoxUI.this.arrowButton.setBounds(n - 18, 0, 18, n2);
                }
                if (TinyComboBoxUI.this.editor != null) {
                    Rectangle rectangle = TinyComboBoxUI.this.rectangleForCurrentValue2();
                    TinyComboBoxUI.this.editor.setBounds(rectangle);
                }
            } else {
                TinyComboBoxUI.this.arrowButton.setBounds(0, 0, n, n2);
            }
        }
    }

    public class TinyPropertyChangeListener
    extends BasicComboBoxUI.PropertyChangeHandler {
        public TinyPropertyChangeListener() {
            super(TinyComboBoxUI.this);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            super.propertyChange(propertyChangeEvent);
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("editable")) {
                TinyComboBoxButton tinyComboBoxButton = (TinyComboBoxButton)TinyComboBoxUI.this.arrowButton;
                tinyComboBoxButton.setIconOnly(TinyComboBoxUI.this.comboBox.isEditable());
                TinyComboBoxUI.this.isMinimumSizeDirty = true;
                TinyComboBoxUI.this.isDisplaySizeDirty = true;
                TinyComboBoxUI.this.comboBox.revalidate();
            } else if (string.equals("background")) {
                Color color = (Color)propertyChangeEvent.getNewValue();
                TinyComboBoxUI.this.listBox.setBackground(color);
            } else if (string.equals("foreground")) {
                Color color = (Color)propertyChangeEvent.getNewValue();
                TinyComboBoxUI.this.listBox.setForeground(color);
            }
        }
    }
}

